% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.test.prop.ps}
\alias{size.test.prop.ps}
\title{Sample size for a test of a paired-samples proportion difference}
\usage{
size.test.prop.ps(alpha, pow, p1, p2, phi, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p1}{planning value of proportion for measurement 1}

\item{p2}{planning value of proportion for measurement 2}

\item{phi}{planning value of phi correlation}

\item{es}{planning value of proportion difference}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a difference in population
proportions with desired power in a paired-samples design. This function
requires planning values for both proportions and a phi coefficient that
describes the correlation between the two dichotomous measurements. The
proportion planning values can set to .5 for a conservatively large sample
size. The planning value for the effect size (proportion difference)
could be set equal to the difference of the two proportion planning values
or it could be set equal to a minimally interesting effect size. Set the
phi correlation planning value to the smallest value within a plausible range
for a conservatively large sample size.
}
\examples{
size.test.prop.ps(.05, .80, .4, .3, .5, .1)

# Should return:
#      Sample size
# [1,]         177


}
