% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median1}
\alias{ci.median1}
\title{Confidence interval for a single median}
\usage{
ci.median1(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median - estimated median
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a single population median.
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40,
       20, 10, 0, 20, 50)
ci.median1(.05, y)

# Should return:
#      Median       SE LL UL
# [1,]     20 4.270922 10 30


}
\references{
\insertRef{Snedecor1980}{statpsych}
}
