% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.stdmean.ws}
\alias{ci.lc.stdmean.ws}
\title{Confidence interval for a standardized linear contrast of means in a
within-subjects design}
\usage{
ci.lc.stdmean.ws(alpha, m, sd, cor, n, q)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of within-subjects estimated means}

\item{sd}{vector of within-subjects estimated standard deviations}

\item{cor}{average estimated correlation of all measurement pairs}

\item{n}{sample size}

\item{q}{vector of within-subjects contrast coefficients}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - bias adjusted standardized linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population standardized linear
contrast of means in a within-subjects design. A square root unweighted
variance standardizer is used. Equality of variances is not assumed but
the correlations among the repeated measures are assumed to be
approximately equal.
}
\examples{
m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.84, 3.84, 3.65, 4.98)
q <- c(.5, .5, -.5, -.5)
ci.lc.stdmean.ws(.05, m, sd, .672, 20, q)

# Should return:
#       Estimate        SE        LL        UL
# [1,] -1.266557 0.1860897 -1.665992 -0.936534


}
\references{
\insertRef{Bonett2008}{statpsych}
}
