% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{sp_get_codelist_file}
\alias{sp_get_codelist_file}
\title{Download a codelist XML file}
\usage{
sp_get_codelist_file(
  codelist_id = NULL,
  url = NULL,
  dest_dir = NULL,
  redownload = FALSE
)
}
\arguments{
\item{codelist_id}{A codelist ID. See \code{id} column in \code{sp_codelists} for a list of available codelists.}

\item{url}{DESCRIPTION. Either this or \code{codelist_id} must be set. If both are set, \code{url} wins.}

\item{dest_dir}{character. Directory in which downloaded files will be stored.
If left unset, will use the \code{statnipokladna.dest_dir} option if the option is set, and \code{tempdir()} otherwise. Will be created if it does not exist.}

\item{redownload}{Redownload even if file has already been downloaded? Defaults to FALSE.}
}
\value{
path to XML file; character vector of length one.
}
\description{
This is normally called inside \code{sp_get_codelist()} but can be used separately if
finer-grained control of intermediate outputs is needed, e.g. in a {targets} workflow.
}
\examples{
\dontrun{
sp_get_codelist_file("druhuj")
codelist_url <- sp_get_codelist_url("druhuj")
sp_get_codelist_file(url = codelist_url)
}
}
\seealso{
Other Detailed workflow: 
\code{\link{sp_get_dataset_url}()},
\code{\link{sp_get_table_file}()},
\code{\link{sp_load_codelist}()},
\code{\link{sp_load_table}()}
}
\concept{Detailed workflow}
