% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDprob.R
\name{plot.IBDprob}
\alias{plot.IBDprob}
\title{Plot function for objects of class IBDprob}
\usage{
\method{plot}{IBDprob}(
  x,
  ...,
  plotType = c("singleGeno", "allGeno", "pedigree", "meanProbs", "totalCoverage"),
  genotype,
  chr = NULL,
  title = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class \code{IBDprob}.}

\item{...}{Further arguments. Unused.}

\item{plotType}{A character string indicating the type of plot that should
be made.}

\item{genotype}{A character string indicating the genotype for which the
plot should be made. Only for \code{plotType = "singleGeno"}.}

\item{chr}{A character vector indicating the chromosomes to which the
coverage should be restricted. Only for \code{plotType = "meanProbs"} and
\code{plotType = "totalCoverage"}. If \code{NULL} all chromosomes are
included.}

\item{title}{A character string, the title of the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE}, only a ggplot object is invisibly returned.}
}
\value{
A ggplot object is invisibly returned.
}
\description{
Creates a plot for an object of class \code{IBDprob}. Three types of plot can
be made:
\itemize{
\item{\code{singleGeno}}{ A plot for a single genotype showing the IBD
probabilities for all parents across the genome.}
\item{\code{allGeno}}{ A plot showing for all genotypes the IBD
probabilities of the parent with the highest probability per marker.}
\item{\code{pedigree}}{ A plot showing the structure of the pedigree of
the population.}
\item{\code{meanProbs}}{ A plot showing the coverage of each parent across
the population.}
\item{\code{totalCoverage}}{ A plot showing the total coverage of each
parent.}
}
}
\examples{
\dontrun{
## Compute IBD probabilities for Steptoe Morex.
## Add extra evaluation positions in between exiting marker positions
## to assure evaluation positions are at most 2 cM apart.
SxMIBD_Ext <- calcIBD(popType = "DH",
                      markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                              package = "statgenIBD"),
                      mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                           package = "statgenIBD"),
                      evalDist = 2)

## Plot results for genotype dh005.
plot(SxMIBD_Ext,
     plotType = "singleGeno",
     genotype = "dh005")

## Plot results for all genotypes.
plot(SxMIBD_Ext,
     plotType = "allGeno")

## Plot structure of the pedigree.
plot(SxMIBD_Ext,
     plotType = "pedigree")

## Plot coverage across population.
plot(SxMIBD_Ext,
     plotType = "meanProbs")

## Plot total coverage.
plot(SxMIBD_Ext,
     plotType = "totalCoverage")
}

}
