% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFW.R
\name{plot.FW}
\alias{plot.FW}
\title{Plot function for class FW}
\usage{
\method{plot}{FW}(
  x,
  ...,
  plotType = c("scatter", "line", "trellis", "scatterFit"),
  order = c("ascending", "descending"),
  response = c("predicted", "observed"),
  colorGenoBy = NULL,
  colGeno = NULL,
  genotypes = NULL,
  title = paste("Finlay & Wilkinson analysis for", x$trait),
  output = TRUE
)
}
\arguments{
\item{x}{An object of class FW.}

\item{...}{Not used.}

\item{plotType}{A character string indicating which plot should be made.
Either "scatter", "line" or "trellis" for creating a scatter
plot of genotypic means, mse and sensitivities, a plot of fitted lines for
each genotype or a trellis plot of the individual genotype slopes
respectively.}

\item{order}{A character string specifying whether the results in the line
plot should be ordered in an increasing (or decreasing) order of
sensitivities. Ignored if \code{plotType} is not "line".}

\item{response}{A character string specifying whether in the line plot the
"predicted" or the "observed" data should be plotted. Ignored if
\code{plotType} is not "line".}

\item{colorGenoBy}{A character string indicating a column in the \code{TD}
used as input for the Finlay Wilkinson analysis by which the genotypes
should be colored. If \code{NULL} all genotypes will be colored differently.}

\item{colGeno}{A character vector with plot colors for the genotypes. A
single color when \code{colorGenoBy = NULL}, a vector of colors otherwise.}

\item{genotypes}{An optional character string containing the genotypes to
be plotted in the trellis plot. If \code{NULL} all genotypes are plotted.
If more than 64 genotypes are selected, only the first 64 are plotted.}

\item{title}{A character string used a title for the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE}, only a list of ggplot objects is invisibly returned.}
}
\value{
A plot depending on \code{plotType}.
}
\description{
Four types of plot can be made. A scatter plot for genotypic mean,
square root of mean squared deviation and sensitivity, a line plot with
fitted lines for each genotype, a trellis plot with individual slopes per
genotype and a scatter plot of fitted values in the worst and best trial.\cr
It is possible to select genotypes for the trellis plot using the
\code{genotypes} parameter. If there are more than 64 genotypes, only the
first 64 are plotted in the trellis plot.
}
\examples{
## Run Finlay-Wilkinson analysis.
geFW <- gxeFw(TD = TDMaize, trait = "yld")

## Create a scatter plot.
plot(geFW)

## Create a line plot.
plot(geFW, plotType = "line")

## Create a line plot showing observed data value for genotypes and fitted lines.
## Display trials in descending order.
plot(geFW, plotType = "line", order = "descending", response = "observed")

\donttest{
## Create a trellis plot.
plot(geFW, plotType = "trellis")

## Create a scatter plot of fitted values for the worst and best trials.
plot(geFW, plotType = "scatterFit")
}

}
\seealso{
Other Finlay-Wilkinson: 
\code{\link{fitted.FW}()},
\code{\link{gxeFw}()},
\code{\link{report.FW}()},
\code{\link{residuals.FW}()}
}
\concept{Finlay-Wilkinson}
