/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import blbutil.BitList;
import blbutil.Const;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import vcf.Marker;

public final class Markers {
    private final Marker[] markers;
    private final Set<Marker> markerSet;
    private final int[] sumAlleles;
    private final int[] sumGenotypes;
    private final int[] sumHapBits;
    private final int hashCode;

    public static Markers create(Marker[] markerArray) {
        return new Markers(markerArray);
    }

    private Markers(Marker[] markerArray) {
        Markers.checkMarkerPosOrder(markerArray);
        this.markers = (Marker[])markerArray.clone();
        this.markerSet = Markers.markerSet(markerArray);
        this.sumAlleles = Markers.cumSumAlleles(markerArray);
        this.sumGenotypes = Markers.cumSumGenotypes(markerArray);
        this.sumHapBits = Markers.cumSumHaplotypeBits(markerArray);
        this.hashCode = Arrays.deepHashCode(markerArray);
    }

    private static void checkMarkerPosOrder(Marker[] markerArray) {
        if (markerArray.length < 2) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(markerArray[0].chromIndex());
        hashSet.add(markerArray[1].chromIndex());
        for (int i = 2; i < markerArray.length; ++i) {
            int n = markerArray[i - 2].chromIndex();
            int n2 = markerArray[i - 1].chromIndex();
            int n3 = markerArray[i].chromIndex();
            if (n == n2 && n2 == n3) {
                int n4 = markerArray[i - 2].pos();
                int n5 = markerArray[i - 1].pos();
                int n6 = markerArray[i].pos();
                if ((n5 >= n4 || n5 >= n6) && (n5 <= n4 || n5 <= n6)) continue;
                String string = "markers not in chromosomal order: " + Const.nl + markerArray[i - 2] + Const.nl + markerArray[i - 1] + Const.nl + markerArray[i];
                throw new IllegalArgumentException(string);
            }
            if (n2 == n3) continue;
            if (hashSet.contains(n3)) {
                String string = "markers on chromosome are not contiguous: " + ChromIds.instance().id(n3);
                throw new IllegalArgumentException(string);
            }
            hashSet.add(n3);
        }
    }

    private static Set<Marker> markerSet(Marker[] markerArray) {
        HashSet<Marker> hashSet = new HashSet<Marker>(markerArray.length);
        for (Marker marker : markerArray) {
            if (hashSet.add(marker)) continue;
            throw new IllegalArgumentException("Duplicate marker: " + marker);
        }
        return hashSet;
    }

    private static int[] cumSumAlleles(Marker[] markerArray) {
        int[] nArray = new int[markerArray.length + 1];
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + markerArray[i - 1].nAlleles();
        }
        return nArray;
    }

    private static int[] cumSumGenotypes(Marker[] markerArray) {
        int[] nArray = new int[markerArray.length + 1];
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + markerArray[i - 1].nGenotypes();
        }
        return nArray;
    }

    private static int[] cumSumHaplotypeBits(Marker[] markerArray) {
        int[] nArray = new int[markerArray.length + 1];
        for (int i = 1; i < nArray.length; ++i) {
            int n = markerArray[i - 1].nAlleles() - 1;
            int n2 = 32 - Integer.numberOfLeadingZeros(n);
            nArray[i] = nArray[i - 1] + n2;
        }
        return nArray;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Markers markers = (Markers)object;
        return Arrays.deepEquals(this.markers, markers.markers);
    }

    public int size() {
        return this.markers.length;
    }

    public Marker marker(int n) {
        return this.markers[n];
    }

    public Marker[] markers() {
        return (Marker[])this.markers.clone();
    }

    public boolean contains(Marker marker) {
        return this.markerSet.contains(marker);
    }

    public Markers restrict(int n, int n2) {
        if (n2 > this.markers.length) {
            throw new IndexOutOfBoundsException("end > this.nMarkers(): " + n2);
        }
        return new Markers(Arrays.copyOfRange(this.markers, n, n2));
    }

    public Markers restrict(int[] nArray) {
        Marker[] markerArray = new Marker[nArray.length];
        markerArray[0] = this.markers[nArray[0]];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[i - 1]) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            markerArray[i] = this.markers[nArray[i]];
        }
        return new Markers(markerArray);
    }

    public int sumAlleles(int n) {
        return this.sumAlleles[n];
    }

    public int sumAlleles() {
        return this.sumAlleles[this.markers.length];
    }

    public int sumGenotypes(int n) {
        return this.sumGenotypes[n];
    }

    public int sumGenotypes() {
        return this.sumGenotypes[this.markers.length];
    }

    public int sumHapBits(int n) {
        return this.sumHapBits[n];
    }

    public int sumHapBits() {
        return this.sumHapBits[this.markers.length];
    }

    public int[] bitsToAlleles(BitList bitList) {
        int[] nArray = new int[this.markers.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.sumHapBits[i + 1];
            int n2 = this.sumHapBits[i];
            if (n == n2 + 1) {
                nArray[i] = bitList.get(n2) ? 1 : 0;
                continue;
            }
            int n3 = 0;
            int n4 = 1;
            for (int j = n2; j < n; ++j) {
                if (bitList.get(j)) {
                    n3 |= n4;
                }
                n4 <<= 1;
            }
            nArray[i] = n3;
        }
        return nArray;
    }

    public void allelesToBits(int[] nArray, BitList bitList) {
        if (nArray.length != this.markers.length) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (bitList.size() != this.sumHapBits()) {
            throw new IllegalArgumentException(String.valueOf(bitList.size()));
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.markers[i].nAlleles()) {
                String string = "allele \"" + n + "\" out of bounds for marker: " + this.markers[i];
                throw new IllegalArgumentException(string);
            }
            int n2 = 1;
            for (int j = this.sumHapBits[i]; j < this.sumHapBits[i + 1]; ++j) {
                if ((n & n2) == n2) {
                    bitList.set(j);
                } else {
                    bitList.clear(j);
                }
                n2 <<= 1;
            }
        }
    }

    public void setAllele(int n, int n2, BitList bitList) {
        if (bitList.size() != this.sumHapBits()) {
            throw new IllegalArgumentException(String.valueOf(bitList.size()));
        }
        if (n < 0 || n >= this.markers.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 >= this.markers[n].nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        int n3 = 1;
        int n4 = this.sumHapBits[n + 1];
        for (int i = this.sumHapBits[n]; i < n4; ++i) {
            if ((n2 & n3) == n3) {
                bitList.set(i);
            } else {
                bitList.clear(i);
            }
            n3 <<= 1;
        }
    }

    public int allele(BitList bitList, int n) {
        int n2 = this.sumHapBits[n + 1];
        int n3 = this.sumHapBits[n];
        if (n2 == n3 + 1) {
            return bitList.get(n3) ? 1 : 0;
        }
        int n4 = 0;
        int n5 = 1;
        for (int i = n3; i < n2; ++i) {
            if (bitList.get(i)) {
                n4 |= n5;
            }
            n5 <<= 1;
        }
        return n4;
    }

    public String toString() {
        return Arrays.toString(this.markers);
    }
}

