% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{dplyr}
\alias{dplyr}
\alias{filter.stars}
\alias{filter.stars_proxy}
\alias{mutate.stars}
\alias{mutate.stars_proxy}
\alias{transmute.stars}
\alias{transmute.stars_proxy}
\alias{select.stars}
\alias{select.stars_proxy}
\alias{pull.stars}
\alias{pull.stars_proxy}
\alias{as.tbl_cube.stars}
\alias{slice.stars}
\alias{slice.stars_proxy}
\alias{replace_na.stars}
\alias{replace_na.stars_proxy}
\title{dplyr verbs for stars objects}
\usage{
filter.stars(.data, ...)

filter.stars_proxy(.data, ...)

mutate.stars(.data, ...)

mutate.stars_proxy(.data, ...)

transmute.stars(.data, ...)

transmute.stars_proxy(.data, ...)

select.stars(.data, ...)

select.stars_proxy(.data, ...)

pull.stars(.data, var = -1)

pull.stars_proxy(.data, ...)

as.tbl_cube.stars(x, ...)

slice.stars(.data, along, index, ..., drop = length(index) == 1)

slice.stars_proxy(.data, ...)

replace_na.stars(data, replace, ...)

replace_na.stars_proxy(data, ...)
}
\arguments{
\item{.data}{object of class \code{stars}}

\item{...}{see \link[dplyr]{filter}}

\item{var}{see \link[dplyr]{pull}}

\item{x}{object of class \code{stars}}

\item{along}{name or index of dimension to which the slice should be applied}

\item{index}{integer value(s) for this index}

\item{drop}{logical; drop dimensions that only have a single index?}

\item{data}{data set to work on}

\item{replace}{see \link[tidyr]{replace_na}: list with variable=value pairs, where value is the replacement value for NA's}
}
\description{
dplyr verbs for stars objects; package dplyr needs to be loaded before these methods can be used for stars objects.
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x1 = read_stars(tif)
library(dplyr)
x1 \%>\% slice("band", 2:3)
x1 \%>\% slice("x", 50:100)
}
