% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdf.R
\name{read_ncdf}
\alias{read_ncdf}
\title{Read NetCDF into stars object}
\usage{
read_ncdf(.x, ..., var = NULL, ncsub = NULL,
  curvilinear = character(0))
}
\arguments{
\item{.x}{NetCDF file or source}

\item{...}{ignored}

\item{var}{variable name or names (they must be on matching grids)}

\item{ncsub}{matrix of start, count columns (see Details)}

\item{curvilinear}{length two character vector with names of subdatasets holding longitude and latitude values for all raster cells.}
}
\description{
Read data from a file (or source) using the NetCDF library directly.
}
\details{
The following logic is applied to coordinates. If any coordinate axes have
regularly spaced coordinate variables they are reduced to the
offset/delta form with 'affine = c(0, 0)', otherwise the values of the coordinates
are stored and used to define a rectilinear grid.

If the data has two or more dimensions and the first two are regular
they are nominated as the 'raster' for plotting.

If the \code{curvilinear} argument is used it specifies the 2D arrays
containing coordinate values for the first two dimensions of the data read. It is currently
assumed that the coordinates are 2D and that they relate to the first two dimensions in
that order.


If `var` is not set the first set of variables on a shared grid is used.
It's supposed to be the grid with the most dimensions, but there's no control
yet (see `ncmeta::nc_grids(.x)` for the current assumption).

\code{start} and \code{count} columns of ncsub must correspond to the variable dimemsion (nrows)
and be valid index using `RNetCDF::var.get.nc` convention (start is 1-based). If the count value
is `NA` then all steps are included. Axis order must match that of the variable/s being read.
}
\examples{
f <- system.file("nc/reduced.nc", package = "stars")
read_ncdf(f)
read_ncdf(f, var = c("anom"))
read_ncdf(f, ncsub = cbind(start = c(1, 1, 1, 1), count = c(10, 12, 1, 1)))


#' precipitation data in a curvilinear NetCDF
prec_file = system.file("nc/test_stageiv_xyt.nc", package = "stars")
prec = read_ncdf(prec_file, curvilinear = c("lon", "lat"))

##plot(prec) ## gives error about unique breaks
## remove NAs, zeros, and give a large number
## of breaks (used for validating in detail)
qu_0_omit = function(x, ..., n = 22) {
  x = na.omit(x)
  c(0, quantile(x[x > 0], seq(0, 1, length.out = n)))
}
prec_slice = stars::slice.stars(prec, index = 17, along = "time")
plot(prec_slice, border = NA, breaks = qu_0_omit(prec_slice[[1]]), reset = FALSE)
nc = sf::read_sf(system.file("gpkg/nc.gpkg", package = "sf"), "nc.gpkg")
plot(st_geometry(nc), add = TRUE, reset = FALSE, col = NA)
}
