% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-conversion-functions.R
\name{as_sevt}
\alias{as_sevt}
\alias{as_sevt.bn.fit}
\alias{as_sevt.bn}
\alias{as_sevt.parentslist}
\title{Coerce to sevt}
\usage{
as_sevt(x, ...)

\method{as_sevt}{bn.fit}(x, order = NULL, ...)

\method{as_sevt}{bn}(x, order = NULL, values = NULL, ...)

\method{as_sevt}{parentslist}(x, order = NULL, values = NULL, ...)
}
\arguments{
\item{x}{an R object.}

\item{...}{additional parameters to be used by specific methods.}

\item{order}{order of the variables.}

\item{values}{the values for each variable, the sample space.}
}
\value{
the equivalent object of class \code{\link{sevt}}.
}
\description{
Convert to an equivalent object of class \code{\link{sevt}}.
}
\details{
In \code{as_sevt.bn.fit} the \code{order}
argument, if provided, must be a topological order of the
\code{bn.fit} object (no check is performed). If the order is not provided
a topological order will be used (the one returned by
\code{bnlearn::node.ordering}).

In \code{as_sevt.parentslist} the \code{order}
argument, if provided, must be a topological order of the
corresponding DAG (no check is performed).
If the order is not provided
\code{names(x)} is used.

The \code{values} parameter is used to specify the sample space
of each variable. For a \code{parentslist} object created with
\code{\link{as_parentslist}} from an object of class \code{sevt},
it is, usually, not needed to specify the \code{values} parameter,
since the sample space is saved in the \code{parentslist} object.
}
\examples{
model <- stages_hclust(full(Titanic), k = 2)
plot(model)
pl <- as_parentslist(model)
model2 <- as_sevt(pl)
plot(model2) ## this is a super-model of the first staged tree
## we can check it with
inclusions_stages(model, model2)
}
