% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_parquan.R
\name{charge_with_filter,ref_parquan-method}
\alias{charge_with_filter,ref_parquan-method}
\title{Loading method for Reparquan referential objects searching only those parameters existing for a DC (counting device), a Taxon, and a stage}
\usage{
\S4method{charge_with_filter}{ref_parquan}(object, dc_selected, taxa_selected, stage_selected)
}
\arguments{
\item{object}{An object of class \link{ref_parquan-class}}

\item{dc_selected}{The dc set in the report object}

\item{taxa_selected}{The taxa set in the report object}

\item{stage_selected}{The stage set in the report object}
}
\value{
An S4 object of class \link{ref_parquan-class} with data loaded showing available parameters for one DC
}
\description{
Loading method for Reparquan referential objects searching only those parameters existing for a DC (counting device), a Taxon, and a stage
}
\examples{
\dontrun{
 dc_selected=6
taxa_selected=2038
 stage_selected='AGJ'
 object=new('ref_parquan')
 charge_with_filter(object,dc_selected,taxa_selected,stage_selected)
}  
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
