% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_parqual.R
\docType{methods}
\name{charge_with_filter,ref_parqual-method}
\alias{charge_with_filter,ref_parqual-method}
\title{Loading method for Reparqual referential objects searching only those parameters existing for a DC, a Taxon, and a stage}
\usage{
\S4method{charge_with_filter}{ref_parqual}(object, dc_selectionne,
  taxa_selectionne, stage_selectionne)
}
\arguments{
\item{object}{An object of class \link{ref_parqual-class}}

\item{dc_selectionne}{The dc set in the report object}

\item{taxa_selectionne}{The taxa set in the report object}

\item{stage_selectionne}{The stage set in the report object}
}
\value{
An S4 object of class \link{ref_parqual-class}
}
\description{
Loading method for Reparqual referential objects searching only those parameters existing for a DC, a Taxon, and a stage
}
\examples{
\dontrun{
 dc_selectionne=6
taxa_selectionne=2038
 stage_selectionne="AGJ"
 object=new("ref_parqual")
 charge_with_filter(object,dc_selectionne,taxa_selectionne,stage_selectionne)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
