% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModelFitness.R
\name{getModelFitness}
\alias{getModelFitness}
\title{Scoring the given SEM models.}
\usage{
getModelFitness(theData = NULL, allModelString = NULL, numTime = NULL,
  longitudinal = NULL, co = NULL)
}
\arguments{
\item{theData}{a data frame containing the data to which the model is to
be fit. If parameter \code{longitudinal} is \code{TRUE}, the data frame
should be reshaped such that the first \code{n} data points contain the
relations that occur in the first two time slices \code{t_0} and \code{t_1}.
The next \code{n} data points contain the relations that occur in
time slices \code{t_1} and \code{t_2}. The \code{i-th} subset of \code{n}
data points contain the relations in time slices \code{t_i-1} and \code{t_i}.}

\item{allModelString}{\code{m} by \code{n} \code{\link{matrix}} of
binary vectors representing models, where \code{m} is the number of models,
and \code{n} is the length of the binary vector.}

\item{numTime}{number of time slices. If a cross-sectional data then the
it is 1.}

\item{longitudinal}{\code{TRUE} for longitudinal data,
and \code{FALSE} for cross-sectional data.}

\item{co}{whether to use \code{"covariance"} or \code{"correlation"}
\code{\link{matrix}}.}
}
\value{
a \code{\link{matrix}} of models including their fitness':
\code{chi-square} and \code{model complexity.}
}
\description{
Compute the model \code{chi-square} and \code{model complexity}
of the given SEM models.
}
\examples{
\donttest{
the_data <- adhd
models <- modelPop(nPop=25, numVar=6, longitudinal=FALSE,
consMatrix = matrix(c(1, 2), 1, 2))

model_fitness <- getModelFitness(theData=the_data,
allModelString=models, numTime=1, longitudinal=FALSE, co="covariance")
model_fitness}
}
\author{
Ridho Rahmadi \email{r.rahmadi@cs.ru.nl}
}

