% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/er_anova.R
\name{er_anova}
\alias{er_anova}
\alias{er_anova.default}
\title{Eberhart & Russel’s Model ANOVA}
\usage{
er_anova(.data, .y, .rep, .gen, .env)

\method{er_anova}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Additive ANOVA
}
\description{
ANOVA of Eberhart & Russel’s Model
}
\examples{

data(ge_data)
Yield.er_anova <-
         er_anova(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
          )
Yield.er_anova


}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
