% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneticAlgorithm.R
\name{GAfit}
\alias{GAfit}
\title{Genetic algorithm for preliminary estimation of reduced form STVAR models}
\usage{
GAfit(
  data,
  p,
  M,
  weight_function = c("relative_dens", "logistic", "mlogit", "exponential", "threshold",
    "exogenous"),
  weightfun_pars = NULL,
  cond_dist = c("Gaussian", "Student", "ind_Student", "ind_skewed_t"),
  parametrization = c("intercept", "mean"),
  AR_constraints = NULL,
  mean_constraints = NULL,
  weight_constraints = NULL,
  ngen = 200,
  popsize,
  smart_mu = min(100, ceiling(0.5 * ngen)),
  initpop = NULL,
  mu_scale,
  mu_scale2,
  omega_scale,
  B_scale,
  weight_scale,
  ar_scale = 0.2,
  upper_ar_scale = 1,
  ar_scale2 = 1,
  regime_force_scale = 1,
  penalized,
  penalty_params = c(0.05, 0.5),
  allow_unstab,
  red_criteria = c(0.05, 0.01),
  bound_by_weights,
  pre_smart_mu_prob = 0,
  to_return = c("alt_ind", "best_ind"),
  minval,
  fixed_params = NULL,
  fixed_params_in_smart_mu = TRUE,
  seed = NULL
)
}
\arguments{
\item{data}{a matrix or class \code{'ts'} object with \code{d>1} columns. Each column is taken to represent
a univariate time series. Missing values are not supported.}

\item{p}{a positive integer specifying the autoregressive order}

\item{M}{a positive integer specifying the number of regimes}

\item{weight_function}{What type of transition weights \eqn{\alpha_{m,t}} should be used?
\describe{
  \item{\code{"relative_dens"}:}{\eqn{\alpha_{m,t}=
    \frac{\alpha_mf_{m,dp}(y_{t-1},...,y_{t-p+1})}{\sum_{n=1}^M\alpha_nf_{n,dp}(y_{t-1},...,y_{t-p+1})}}, where
    \eqn{\alpha_m\in (0,1)} are weight parameters that satisfy \eqn{\sum_{m=1}^M\alpha_m=1} and
    \eqn{f_{m,dp}(\cdot)} is the \eqn{dp}-dimensional stationary density of the \eqn{m}th regime corresponding to \eqn{p}
    consecutive observations. Available for Gaussian conditional distribution only.}
  \item{\code{"logistic"}:}{\eqn{M=2}, \eqn{\alpha_{1,t}=1-\alpha_{2,t}},
    and \eqn{\alpha_{2,t}=[1+\exp\lbrace -\gamma(y_{it-j}-c) \rbrace]^{-1}}, where \eqn{y_{it-j}} is the lag \eqn{j}
    observation of the \eqn{i}th variable, \eqn{c} is a location parameter, and \eqn{\gamma > 0} is a scale parameter.}
  \item{\code{"mlogit"}:}{\eqn{\alpha_{m,t}=\frac{\exp\lbrace \gamma_m'z_{t-1} \rbrace}
    {\sum_{n=1}^M\exp\lbrace \gamma_n'z_{t-1} \rbrace}}, where \eqn{\gamma_m} are coefficient vectors, \eqn{\gamma_M=0},
    and \eqn{z_{t-1}} \eqn{(k\times 1)} is the vector containing a constant and the (lagged) switching variables.}
  \item{\code{"exponential"}:}{\eqn{M=2}, \eqn{\alpha_{1,t}=1-\alpha_{2,t}},
    and \eqn{\alpha_{2,t}=1-\exp\lbrace -\gamma(y_{it-j}-c) \rbrace}, where \eqn{y_{it-j}} is the lag \eqn{j}
    observation of the \eqn{i}th variable, \eqn{c} is a location parameter, and \eqn{\gamma > 0} is a scale parameter.}
  \item{\code{"threshold"}:}{\eqn{\alpha_{m,t} = 1} if \eqn{r_{m-1}<y_{it-j}\leq r_{m}} and \eqn{0} otherwise, where
     \eqn{-\infty\equiv r_0<r_1<\cdots <r_{M-1}<r_M\equiv\infty} are thresholds \eqn{y_{it-j}} is the lag \eqn{j}
     observation of the \eqn{i}th variable.}
  \item{\code{"exogenous"}:}{Exogenous nonrandom transition weights, specify the weight series in \code{weightfun_pars}.}
}
See the vignette for more details about the weight functions.}

\item{weightfun_pars}{\describe{
  \item{If \code{weight_function == "relative_dens"}:}{Not used.}
  \item{If \code{weight_function \%in\% c("logistic", "exponential", "threshold")}:}{a numeric vector with the switching variable
    \eqn{i\in\lbrace 1,...,d \rbrace} in the first and the lag \eqn{j\in\lbrace 1,...,p \rbrace} in the second element.}
  \item{If \code{weight_function == "mlogit"}:}{a list of two elements:
    \describe{
      \item{The first element \code{$vars}:}{a numeric vector containing the variables that should used as switching variables
        in the weight function in an increasing order, i.e., a vector with unique elements in \eqn{\lbrace 1,...,d \rbrace}.}
      \item{The second element \code{$lags}:}{an integer in \eqn{\lbrace 1,...,p \rbrace} specifying the number of lags to be
        used in the weight function.}
    }
  }
  \item{If \code{weight_function == "exogenous"}:}{a size (\code{nrow(data) - p} x \code{M}) matrix containing the exogenous
    transition weights as \code{[t, m]} for time \eqn{t} and regime \eqn{m}. Each row needs to sum to one and only weakly positive
    values are allowed.}
}}

\item{cond_dist}{specifies the conditional distribution of the model as \code{"Gaussian"}, \code{"Student"}, \code{"ind_Student"},
or \code{"ind_skewed_t"}, where \code{"ind_Student"} the Student's \eqn{t} distribution with independent components, and
\code{"ind_skewed_t"} is the skewed \eqn{t} distribution with independent components (see Hansen, 1994).}

\item{parametrization}{\code{"intercept"} or \code{"mean"} determining whether the model is parametrized with intercept
parameters \eqn{\phi_{m,0}} or regime means \eqn{\mu_{m}}, m=1,...,M.}

\item{AR_constraints}{a size \eqn{(Mpd^2 \times q)} constraint matrix \eqn{C} specifying linear constraints
to the autoregressive parameters. The constraints are of the form
\eqn{(\varphi_{1},...,\varphi_{M}) = C\psi}, where \eqn{\varphi_{m} = (vec(A_{m,1}),...,vec(A_{m,p})) \ (pd^2 \times 1),\ m=1,...,M},
contains the coefficient matrices and \eqn{\psi} \eqn{(q \times 1)} contains the related parameters.
For example, to restrict the AR-parameters to be the identical across the regimes, set \eqn{C =}
[\code{I:...:I}]' \eqn{(Mpd^2 \times pd^2)} where \code{I = diag(p*d^2)}.}

\item{mean_constraints}{Restrict the mean parameters of some regimes to be identical? Provide a list of numeric vectors
such that each numeric vector contains the regimes that should share the common mean parameters. For instance, if
\code{M=3}, the argument \code{list(1, 2:3)} restricts the mean parameters of the second and third regime to be
identical but the first regime has freely estimated (unconditional) mean. Ignore or set to \code{NULL} if mean parameters
should not be restricted to be the same among any regimes. This constraint is available only for mean parametrized models;
that is, when \code{parametrization="mean"}.}

\item{weight_constraints}{a list of two elements, \eqn{R} in the first element and \eqn{r} in the second element,
specifying linear constraints on the transition weight parameters \eqn{\alpha}.
The constraints are of the form \eqn{\alpha = R\xi + r}, where \eqn{R} is a known \eqn{(a\times l)}
constraint matrix of full column rank (\eqn{a} is the dimension of \eqn{\alpha}), \eqn{r} is a known \eqn{(a\times 1)} constant,
and \eqn{\xi} is an unknown \eqn{(l\times 1)} parameter. \strong{Alternatively}, set \eqn{R=0} to constrain the
weight parameters to the constant \eqn{r} (in this case, \eqn{\alpha} is dropped from the constrained parameter vector).}

\item{ngen}{a positive integer specifying the number of generations to be ran through in
the genetic algorithm.}

\item{popsize}{a positive even integer specifying the population size in the genetic algorithm.
Default is \code{10*n_params}.}

\item{smart_mu}{a positive integer specifying the generation after which the random mutations
in the genetic algorithm are "smart". This means that mutating individuals will mostly mutate fairly
close (or partially close) to the best fitting individual (which has the least regimes with time varying
mixing weights practically at zero) so far.}

\item{initpop}{a list of parameter vectors from which the initial population of the genetic algorithm
will be generated from. The parameter vectors hould have the form
\eqn{\theta = (\phi_{1,0},...,\phi_{M,0},\varphi_1,...,\varphi_M,\sigma,\alpha,\nu)}, where (see exceptions below):
\itemize{
  \item{\eqn{\phi_{m,0} = } the \eqn{(d \times 1)} intercept (or mean) vector of the \eqn{m}th regime.}
  \item{\eqn{\varphi_m = (vec(A_{m,1}),...,vec(A_{m,p}))} \eqn{(pd^2 \times 1)}.}
  \item{\describe{
    \item{if \code{cond_dist="Gaussian"} or \code{"Student"}:}{\eqn{\sigma = (vech(\Omega_1),...,vech(\Omega_M))}
      \eqn{(Md(d + 1)/2 \times 1)}.}
    \item{if \code{cond_dist="ind_Student"} or \code{"ind_skewed_t"}:}{\eqn{\sigma = (vec(B_1),...,vec(B_M)} \eqn{(Md^2 \times 1)}.}
    }
  }
  \item{\eqn{\alpha = } the \eqn{(a\times 1)} vector containing the transition weight parameters (see below).}
  \item{\describe{
    \item{if \code{cond_dist = "Gaussian")}:}{Omit \eqn{\nu} from the parameter vector.}
    \item{if \code{cond_dist="Student"}:}{\eqn{\nu > 2} is the single degrees of freedom parameter.}
    \item{if \code{cond_dist="ind_Student"}:}{\eqn{\nu = (\nu_1,...,\nu_d)} \eqn{(d \times 1)}, \eqn{\nu_i > 2}.}
    \item{if \code{cond_dist="ind_skewed_t"}:}{\eqn{\nu = (\nu_1,...,\nu_d,\lambda_1,...,\lambda_d)} \eqn{(2d \times 1)},
     \eqn{\nu_i > 2} and \eqn{\lambda_i \in (0, 1)}.}
    }
  }
}
For models with...
\describe{
  \item{\code{weight_function="relative_dens"}:}{\eqn{\alpha = (\alpha_1,...,\alpha_{M-1})}
        \eqn{(M - 1 \times 1)}, where \eqn{\alpha_m} \eqn{(1\times 1), m=1,...,M-1} are the transition weight parameters.}
 \item{\code{weight_function="logistic"}:}{\eqn{\alpha = (c,\gamma)}
        \eqn{(2 \times 1)}, where \eqn{c\in\mathbb{R}} is the location parameter and \eqn{\gamma >0} is the scale parameter.}
  \item{\code{weight_function="mlogit"}:}{\eqn{\alpha = (\gamma_1,...,\gamma_M)} \eqn{((M-1)k\times 1)},
        where \eqn{\gamma_m} \eqn{(k\times 1)}, \eqn{m=1,...,M-1} contains the multinomial logit-regression coefficients
        of the \eqn{m}th regime. Specifically, for switching variables with indices in \eqn{I\subset\lbrace 1,...,d\rbrace}, and with
       \eqn{\tilde{p}\in\lbrace 1,...,p\rbrace} lags included, \eqn{\gamma_m} contains the coefficients for the vector
       \eqn{z_{t-1} = (1,\tilde{z}_{\min\lbrace I\rbrace},...,\tilde{z}_{\max\lbrace I\rbrace})}, where
       \eqn{\tilde{z}_{i} =(y_{it-1},...,y_{it-\tilde{p}})}, \eqn{i\in I}. So \eqn{k=1+|I|\tilde{p}}
       where \eqn{|I|} denotes the number of elements in \eqn{I}.}
  \item{\code{weight_function="exponential"}:}{\eqn{\alpha = (c,\gamma)}
        \eqn{(2 \times 1)}, where \eqn{c\in\mathbb{R}} is the location parameter and \eqn{\gamma >0} is the scale parameter.}
  \item{\code{weight_function="threshold"}:}{\eqn{\alpha = (r_1,...,r_{M-1})}
        \eqn{(M-1 \times 1)}, where \eqn{r_1,...,r_{M-1}} are the threshold values.}
  \item{\code{weight_function="exogenous"}:}{Omit \eqn{\alpha} from the parameter vector.}
  \item{AR_constraints:}{Replace \eqn{\varphi_1,...,\varphi_M} with \eqn{\psi} as described in the argument \code{AR_constraints}.}
  \item{mean_constraints:}{Replace \eqn{\phi_{1,0},...,\phi_{M,0}} with \eqn{(\mu_{1},...,\mu_{g})} where
        \eqn{\mu_i, \ (d\times 1)} is the mean parameter for group \eqn{i} and \eqn{g} is the number of groups.}
  \item{weight_constraints:}{If linear constraints are imposed, replace \eqn{\alpha} with \eqn{\xi} as described in the
   argument \code{weigh_constraints}. If weight functions parameters are imposed to be fixed values, simply drop \eqn{\alpha}
   from the parameter vector.}
}
Above, \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}th coefficient matrix of the \eqn{m}th
regime, \eqn{\Omega_{m}} denotes the positive definite error term covariance matrix of the \eqn{m}th regime, and \eqn{B_m}
is the invertible \eqn{(d\times d)} impact matrix of the \eqn{m}th regime. \eqn{\nu_m} is the degrees of freedom parameter
of the \eqn{m}th regime.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks columns
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.}

\item{mu_scale}{a size \eqn{(dx1)} vector defining \strong{means} of the normal distributions from which each
mean parameter \eqn{\mu_{m}} is drawn from in random mutations. Default is \code{colMeans(data)}. Note that
mean-parametrization is always used for optimization in \code{GAfit} - even when \code{parametrization=="intercept"}.
However, input (in \code{initpop}) and output (return value) parameter vectors can be intercept-parametrized.}

\item{mu_scale2}{a size \eqn{(dx1)} strictly positive vector defining \strong{standard deviations} of the normal
distributions from which each mean parameter \eqn{\mu_{m}} is drawn from in random mutations.
Default is \code{vapply(1:d, function(i1) sd(data[,i1]), numeric(1))}.}

\item{omega_scale}{a size \eqn{(dx1)} strictly positive vector specifying the scale and variability of the
random covariance matrices in random mutations. The covariance matrices are drawn from (scaled) Wishart
distribution. Expected values of the random covariance matrices are \code{diag(omega_scale)}. Standard
deviations of the diagonal elements are \code{sqrt(2/d)*omega_scale[i]}
and for non-diagonal elements they are \code{sqrt(1/d*omega_scale[i]*omega_scale[j])}.
Note that for \code{d>4} this scale may need to be chosen carefully. Default in \code{GAfit} is
\code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}. This argument is ignored if
\code{cond_dist == "ind_Student"}.}

\item{B_scale}{a size \eqn{(d \times 1)} strictly positive vector specifying the mean and variability of the
random impact matrices in random mutations. In Regime 1, the mean of the error term covariance matrix
implied by the random impact matrix will be \code{0.95*diag(B_scale)} and in the rest of the regimes \code{diag(B_scale)},
whereas the variability increases with \code{B_scale}.
Default in \code{GAfit} is \code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}.
This argument is ignored if \code{cond_dist != "ind_Student"}.}

\item{weight_scale}{For...
\describe{
  \item{\code{weight_function \%in\% c("relative_dens", "exogenous")}:}{not used.}
  \item{\code{weight_function \%in\% c("logistic", "exponential")}:}{length three vector with the mean (in the first element)
     and standard deviation (in the second element) of the normal distribution the location parameter is drawn from
     in random mutations. The third element is the standard deviation of the normal distribution from whose absolute value
     the location parameter is drawn from.}
  \item{\code{weight_function == "mlogit"}:}{length two vector with the mean (in the first element)
     and standard deviation (in the second element) of the normal distribution the coefficients of the logit sub model's
     constant terms are drawn from in random mutations. The third element is the standard deviation of the normal distribution
     from which the non-constant regressors' coefficients are drawn from.}
  \item{\code{weight_function == "threshold"}:}{a lenght two vector with the lower bound, in the first element
     and the upper bound, in the second element, of the uniform distribution threshold parameters are drawn from
     in random mutations.}
}}

\item{ar_scale}{a positive real number between zero and one adjusting how large AR parameter values are typically
proposed in construction of the initial population: larger value implies larger coefficients (in absolute value).
After construction of the initial population, a new scale is drawn from \code{(0, upper_ar_scale)} uniform
distribution in each iteration.}

\item{upper_ar_scale}{the upper bound for \code{ar_scale} parameter (see above) in the random mutations. Setting
this too high might lead to failure in proposing new parameters that are well enough inside the parameter space,
and especially with large \code{p} one might want to try smaller upper bound (e.g., 0.5). With large \code{p} or
\code{d}, \code{upper_ar_scale} is restricted from above, see the details section.}

\item{ar_scale2}{a positive real number adjusting how large AR parameter values are typically proposed in some
random mutations (if AR constraints are employed, in all random mutations): larger value implies \strong{smaller}
coefficients (in absolute value). \strong{Values larger than 1 can be used if the AR coefficients are expected to
be very small. If set smaller than 1, be careful as it might lead to failure in the creation of parameter candidates
that satisfy the stability condition.}}

\item{regime_force_scale}{a non-negative real number specifying how much should natural selection favor individuals
with less regimes that have almost all mixing weights (practically) at zero. Set to zero for no favoring or large
number for heavy favoring. Without any favoring the genetic algorithm gets more often stuck in an area of the
parameter space where some regimes are wasted, but with too much favouring the best genes might never mix into
the population and the algorithm might converge poorly. Default is \code{1} and it gives \eqn{2x} larger surviving
probability weights for individuals with no wasted regimes compared to individuals with one wasted regime.
Number \code{2} would give \eqn{3x} larger probability weights etc.}

\item{penalized}{Perform penalized LS estimation that minimizes penalized RSS in which estimates close to breaking or not satisfying the
usual stability condition are penalized? If \code{TRUE}, the tuning parameter is set by the argument \code{penalty_params[2]},
and the penalization starts when the eigenvalues of the companion form AR matrix are larger than \code{1 - penalty_params[1]}.}

\item{penalty_params}{a numeric vector with two positive elements specifying the penalization parameters:
the first element determined how far from the boundary of the stability region the penalization starts
(a number between zero and one, smaller number starts penalization closer to the boundary) and the second element
is a tuning parameter for the penalization (a positive real number, a higher value penalizes non-stability more).}

\item{allow_unstab}{If \code{TRUE}, estimates not satisfying the stability condition are allowed. Always \code{FALSE} if
\code{weight_function="relative_dens"}.}

\item{red_criteria}{a length 2 numeric vector specifying the criteria that is used to determine whether a regime is
redundant (or "wasted") or not.
Any regime \code{m} which satisfies \code{sum(transitionWeights[,m] > red_criteria[1]) < red_criteria[2]*n_obs} will
be considered "redundant". One should be careful when adjusting this argument (set \code{c(0, 0)} to fully disable
the 'redundant regime' features from the algorithm).}

\item{bound_by_weights}{should the parameter space be constrained to areas where the transition weights do allocate
enough weights to each regime compared to the number of observations in the regime? See the source code of
the function \code{loglikelihood} for details.}

\item{pre_smart_mu_prob}{A number in \eqn{[0,1]} giving a probability of a "smart mutation" occuring randomly in each
iteration before the iteration given by the argument \code{smart_mu}.}

\item{to_return}{should the genetic algorithm return the best fitting individual which has "positive enough" mixing
weights for as many regimes as possible (\code{"alt_ind"}) or the individual which has the highest log-likelihood
in general (\code{"best_ind"}) but might have more wasted regimes?}

\item{minval}{a real number defining the minimum value of the log-likelihood function that will be considered.
Values smaller than this will be treated as they were \code{minval} and the corresponding individuals will
never survive. The default is \code{-(10^(ceiling(log10(n_obs)) + d) - 1)}.}

\item{fixed_params}{a vector containing fixed parameter values for intercept, autoregressive, and weight parameters
that should be fixed in the \strong{initial population}. Should have the form:
\eqn{(\phi_{1,0},...,\phi_{M,0},\varphi_1,...,\varphi_M,\alpha}, where
\itemize{
  \item{\eqn{(\phi_{m,0} = } the \eqn{(d \times 1)} intercept vector of the \eqn{m}th regime.}
  \item{\eqn{\varphi_m = (vec(A_{m,1}),...,vec(A_{m,p}))} \eqn{(pd^2 \times 1)}.}
  \item{\eqn{\alpha} vector of the weight parameters.}
}
For models with...
\describe{
  \item{AR_constraints:}{Replace \eqn{\varphi_1,...,\varphi_M} with \eqn{\psi} as described in the argument \code{AR_constraints}.}
  \item{weight_constraints:}{If linear constraints are imposed, replace \eqn{\alpha} with \eqn{\xi} as described in the
   argument \code{weigh_constraints}. If weight functions parameters are imposed to be fixed values, simply drop \eqn{\alpha}
   from the parameter vector.}
}
Note that \code{fixed_params} should always be in the intercept parametrization (and \code{parametrization="intercept"} should always be used).
\strong{Passing this argument from fitSTVAR in does not do anything, as it is designed to be used with the three-phase estimation
        procedure only. Also, this argument does not do anything if the initial population is specified in the argument initpop.}}

\item{fixed_params_in_smart_mu}{should the fixed parameters be fixed in the smart mutation phase as well? If \code{TRUE}, the fixed
parameters stay fixed throughout the whole GA estimation.}

\item{seed}{a single value, interpreted as an integer, or NULL, that sets seed for the random number generator in
the beginning of the function call. If calling \code{GAfit} from \code{fitSTVAR}, use the argument \code{seeds}
instead of passing the argument \code{seed}.}
}
\value{
Returns the estimated parameter vector which has the form described in \code{initpop},
 \strong{with the exception} that for models with \code{cond_dist == "ind_Student"} or
 \code{"ind_skewed_t"}, the parameter vector is parametrized with \eqn{B_1,B_2^*,...,B_M^*}
 instead of  \eqn{B_1,B_2,...,B_M}, where \eqn{B_m^* = B_m - B_1}. Use the function \code{change_parametrization}
 to change back to the original parametrization if desired.
}
\description{
\code{GAfit} estimates the specified reduced form STVAR model using a genetic algorithm.
  It is designed to find starting values for gradient based methods and NOT to obtain final estimates
  constituting a local maximum.
}
\details{
Only reduced form models are supported!

 The core of the genetic algorithm is mostly based on the description by \emph{Dorsey and Mayer (1995)}.
 It utilizes a slightly modified version of the individually adaptive crossover and mutation rates described
 by \emph{Patnaik and Srinivas (1994)} and employs (50\%) fitness inheritance discussed by
 \emph{Smith, Dike and Stegmann (1995)}.

 By "redundant" or "wasted" regimes we mean regimes that have the time varying mixing weights practically at
 zero for almost all t. A model including redundant regimes would have about the same log-likelihood value without
 the redundant regimes and there is no purpose to have redundant regimes in a model.

 Some of the AR coefficients are drawn with the algorithm by Ansley and Kohn (1986). However,
 when using large \code{ar_scale} with large \code{p} or \code{d}, numerical inaccuracies caused
 by the imprecision of the float-point presentation may result in errors or nonstationary AR-matrices.
 Using smaller \code{ar_scale} facilitates the usage of larger \code{p} or \code{d}. Therefore, we bound
 \code{upper_ar_scale} from above by \eqn{1-pd/150} when \code{p*d>40} and by \eqn{1} otherwise.

 Structural models are not supported here, as they are best estimated based on reduced form parameter estimates
 using the function \code{fitSSTVAR}.
}
\references{
\itemize{
   \item Ansley C.F., Kohn R. 1986. A note on reparameterizing a vector autoregressive
         moving average model to enforce stationarity. \emph{Journal of statistical computation
         and simulation}, \strong{24}:2,  99-106.
   \item Dorsey R. E. and Mayer W. J. 1995. Genetic algorithms for estimation problems with multiple optima,
         nondifferentiability, and other irregular features. \emph{Journal of Business & Economic Statistics},
        \strong{13}, 53-66.
   \item Patnaik L.M. and Srinivas M. 1994. Adaptive Probabilities of Crossover and Mutation in Genetic Algorithms.
         \emph{Transactions on Systems, Man and Cybernetics} \strong{24}, 656-667.
   \item Smith R.E., Dike B.A., Stegmann S.A. 1995. Fitness inheritance in genetic algorithms.
         \emph{Proceedings of the 1995 ACM Symposium on Applied Computing}, 345-350.
 }
}
