% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangulate_delauney.R
\name{triangulate_delaunay}
\alias{triangulate_delaunay}
\title{Perform delaunay triangulation}
\usage{
triangulate_delaunay(
  boundaries,
  with = NULL,
  boundary = "sfa",
  sample_surface = FALSE,
  sample_points = FALSE,
  nb_samples = NULL,
  min_size = 1000,
  seed = 1,
  ...
)
}
\arguments{
\item{boundaries}{\strong{[sf]} The boundaries to be used.}

\item{with}{\strong{[sf]} A set of data points to use for voronoisation.}

\item{boundary}{\strong{[character]} The column in \code{boundaries} that is to
be used for the stratified sampling.}

\item{sample_surface}{\strong{[logical]} Whether to sample the surfaces in
\code{boundaries}, Default to \code{FALSE}.}

\item{sample_points}{\strong{[logical]} Whether to sample points from \code{with} or
to take all points in \code{with}. Default to \code{TRUE}.}

\item{nb_samples}{\strong{[named character vector]} The number of samples to draw
by boundary polygons (must bear the levels of \code{boundary} as names
or be a single value to be applied to each level).}

\item{min_size}{\strong{[numeric]} The minimum size for a triangle above which it
will be merged (in km2).}

\item{seed}{\strong{[numeric]} Passed onto \code{\link[base:Random]{set.seed()}},
important for reproducibility of sampling.}

\item{...}{
  Arguments passed on to \code{\link[RTriangle:triangulate]{RTriangle::triangulate}}
  \describe{
    \item{\code{p}}{Planar straight line graph object; see
\code{\link[RTriangle]{pslg}}.}
    \item{\code{a}}{Maximum triangle area. If specified, triangles cannot be
larger than this area.}
    \item{\code{q}}{Minimum triangle angle in degrees.}
    \item{\code{Y}}{If \code{TRUE} prohibits the insertion of Steiner points
on the mesh boundary.}
    \item{\code{j}}{If \code{TRUE} jettisons vertices that are not part of
the final triangulation from the output.}
    \item{\code{D}}{If \code{TRUE} produce a conforming Delaunay
triangulation. This ensures that all the triangles in the mesh are
truly Delaunay, and not merely constrained Delaunay.  This option
invokes Ruppert's original algorithm, which splits every
subsegment whose diametral circle is encroached.  It usually
increases the number of vertices and triangles.}
    \item{\code{S}}{Specifies the maximum number of added Steiner points.}
    \item{\code{V}}{Verbosity level. Specify higher values  for more detailed
information about what the Triangle library is doing.}
    \item{\code{Q}}{If \code{TRUE} suppresses all explanation of what the
Triangle library is doing, unless an error occurs.}
  }}
}
\value{
A named list with three elements (each an \code{sf} object):
* \code{patches}, the voronoi polygons generated
* \code{points}, the points used for the tessellation.
}
\description{
Generates delaunay triangles with \link[sfdct:ct_triangulate]{ct_triangulate()}.
}
\examples{
data(borealis_simulated, package = "sspm")
data(sfa_boundaries, package = "sspm")
triangulate_delaunay(sfa_boundaries, with = borealis, sample_surface = TRUE,
                     boundary = "sfa", nb_samples = 10)

}
