% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spike.slab.R
\name{spike.slab}
\alias{spike.slab}
\title{Inconsistency Factors' Spike and Slab}
\usage{
spike.slab(x)
}
\arguments{
\item{x}{An object of class \code{ssifs}.}
}
\value{
An object of class \code{ggplot}.
}
\description{
The function visualizes the inconsistency factor's effect when the inconsistency
factor is included in the Network Meta-Analysis (NMA) model and when is not.
}
\details{
The function creates two density plots for each inconsistency factor based on the inconsistency
factors' effects, which are obtained from the \code{ssifs} model. The former visualizes the effect when the
inconsistency factor is included in the NMA model (spike), while the latter when
is not (slab). A good mixing of the SSIFS model indicates that the spike has high density for values
close to zero whereas the slab is flatter.
}
\examples{
data(Alcohol)

TE <- Alcohol$TE
seTE <- Alcohol$seTE
studlab <- Alcohol$studyid
treat1 <- Alcohol$treat2
treat2 <- Alcohol$treat1

# Stochastic Search Inconsistency Factor Selection using intervention AO-CT as reference.
m <- ssifs(TE, seTE, treat1, treat2, studlab, ref = "AO-CT",
M = 500, B = 100, M_pilot = 300, B_pilot = 100)
spike.slab(m)


}
