% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{keygen}
\alias{keygen}
\title{Make private-public key pair}
\usage{
keygen(
  directory = "~/.ssh",
  type = "rsa",
  password = NULL,
  overwrite_existing = FALSE
)
}
\arguments{
\item{directory}{Character string with path to directory where the key pair
will be written. Default is "~/.ssh".}

\item{type}{Character string defining the key type. Must be one of
\code{c("rsa", "dsa", "ecdsa", "x25519", "ed25529")}. Key lengths are set to
the default as defined in the \emph{openssl}-package. If the key-pair is to
be used with this package make sure that type is set to "rsa".}

\item{password}{Character string with password to protect the private key.
Default value is NULL in which case the private key will not be protected
by a password}

\item{overwrite_existing}{Logical whether existing key files with the similar
names should be overwritten. Set to FALSE by default.}
}
\value{
Nothing will be returned from this function, but a message containing
the directory where the keys were written is provided
}
\description{
Just for the convenience of it, make a key pair that may be used alongside
sship. Please note that by default the private key will not be protected by
a password.
}
\examples{
keygen(directory = tempdir(), overwrite_existing = TRUE)
}
