% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hc-burrlioz.R
\name{ssd_hc_burrlioz}
\alias{ssd_hc_burrlioz}
\title{Hazard Concentrations for Burrlioz Fit}
\usage{
ssd_hc_burrlioz(
  x,
  percent = 5,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.99,
  parametric = FALSE
)
}
\arguments{
\item{x}{The object.}

\item{percent}{A numeric vector of percentages.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits. A value of 10000 is recommended for official guidelines.}

\item{min_pboot}{A number of the minimum proportion of bootstrap samples that must successfully fit
in the sense of returning a likelihood.}

\item{parametric}{A flag specifying whether to perform parametric as opposed to non-parametric bootstrapping.}
}
\value{
A tibble of corresponding hazard concentrations.
}
\description{
Deprecated for \code{\link[=ssd_hc]{ssd_hc()}}.
}
\examples{
fit <- ssd_fit_burrlioz(ssddata::ccme_boron)
ssd_hc_burrlioz(fit)

}
