% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npmle.R
\name{bi.npmle}
\alias{bi.npmle}
\title{Bivariate NPMLE}
\usage{
bi.npmle(D1, D2, maxit = 200, tol = 1e-04, verbose = FALSE)
}
\arguments{
\item{D1}{p x d1 matrix of conditional density values, where the \eqn{ij}th entry is \eqn{f_1(X_{1i};u_{1j})}.}

\item{D2}{p x d2 matrix of conditional density values, where the \eqn{ij}th entry is \eqn{f_2(X_{2i};u_{2j})}.}

\item{maxit}{maximum number of EM iterations}

\item{tol}{error tolerance}

\item{verbose}{TRUE to print the error attained by each EM iteration}
}
\value{
\item{g}{d1 x d2 matrix of probability masses at each grid point}
}
\description{
General nonparametric maximum likelihood estimation for a bivariate mixing distribution, implemented using EM. Assumes that the observed data are tuples \eqn{(X_{1i},X_{2i})} with marginal likelihood
\deqn{\int f_1(X_{1i};u_1)f_2(X_{2i};u_2)dG(u_1,u_2),}
where \eqn{G} is the mixing distribution to be estimated. Suppose there are p observed tuples and \eqn{G} is to be estimated on a grid of d1 x d2 points.
}
\examples{
## generate parameters from mixing distribution
p <- 1000;
set.seed(1); theta1 <- rnorm(p); theta2 <- -theta1+rnorm(p);
## generate observed variables
X1 <- rnorm(p,theta1,1); X2 <- rnorm(p,theta2,1);
## set grid points
d1 <- 25; d2 <- 30;
Theta1 <- seq(min(X1),max(X1),length=d1);
Theta2 <- seq(min(X2),max(X2),length=d2);
## calculate D matrices
D1 <- outer(X1,Theta1,function(x,y){
  dnorm(x,y,1);
});
D2 <- outer(X2,Theta2,function(x,y){
  dnorm(x,y,1);
});
## fit npmle
g <- bi.npmle(D1,D2);
contour(Theta1,Theta2,g);
points(theta1,theta2);

}
