% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD.R
\name{ssMRCD}
\alias{ssMRCD}
\title{Spatially Smoothed MRCD Estimator}
\usage{
ssMRCD(
  X,
  groups = NULL,
  weights,
  lambda = 0.5,
  tuning = list(method = NULL, plot = FALSE, k = 10, repetitions = 5, cont = 0.05),
  TM = NULL,
  alpha = 0.75,
  maxcond = 50,
  maxcsteps = 200,
  n_initialhsets = NULL
)
}
\arguments{
\item{X}{a list of matrices containing the observations per neighborhood sorted, or matrix or data frame containing data.
If matrix or data.frame, group vector has to be given.}

\item{groups}{vector of neighborhood assignments}

\item{weights}{weighting matrix, symmetrical, rows sum up to one and diagonals need to be zero (see also \code{\link[ssMRCD]{geo_weights}} or \code{\link[ssMRCD]{time_weights}} .}

\item{lambda}{numeric between 0 and 1.}

\item{tuning}{default NULL. List of tuning specifications if lambda contains more than one value. See Details.}

\item{TM}{target matrix (optional), default value is the covMcd from robustbase.}

\item{alpha}{numeric, proportion of values included, between 0.5 and 1.}

\item{maxcond}{optional, maximal condition number used for rho-estimation.}

\item{maxcsteps}{maximal number of c-steps before algorithm stops.}

\item{n_initialhsets}{number of initial h-sets, default is 6 times number of neighborhoods.}
}
\value{
The output depends on whether parameters are tuned.
If there is no tuning the output is an object of class \code{"ssMRCD"} containing the following elements:\tabular{ll}{
   \code{MRCDcov} \tab List of ssMRCD-covariance matrices sorted by neighborhood. \cr
   \tab \cr
   \code{MRCDicov} \tab List of inverse ssMRCD-covariance matrices sorted by neighborhood. \cr
   \tab \cr
   \code{MRCDmu} \tab List of ssMRCD-mean vectors sorted by neighborhood. \cr
   \tab \cr
   \code{mX} \tab List of data matrices sorted by neighborhood.\cr
   \tab \cr
   \code{N} \tab Number of neighborhoods. \cr
   \tab \cr
   \code{mT} \tab Target matrix. \cr
   \tab \cr
   \code{rho} \tab Vector of regularization values sorted by neighborhood. \cr
   \tab \cr
   \code{alpha} \tab Scalar what percentage of observations should be used. \cr
   \tab \cr
   \code{h} \tab Vector of how many observations are used per neighborhood, sorted. \cr
   \tab \cr
   \code{numiter} \tab The number of iterations for the best initial h-set combination. \cr
   \tab \cr
   \code{c_alpha} \tab Consistency factor for normality. \cr
   \tab \cr
   \code{weights} \tab The weighting matrix. \cr
   \tab \cr
   \code{lambda} \tab Smoothing factor. \cr
   \tab \cr
   \code{obj_fun_values} \tab A matrix with objective function values for all
initial h-set combinations (rows) and iterations (columns). \cr
   \tab \cr
   \code{best6pack} \tab initial h-set combinations with best objective function value
after c-step iterations. \cr
   \code{Kcov} \tab returns MRCD-estimates without smoothing. \cr
}

If parameters are tuned, the output consists of:\tabular{ll}{
   \code{ssMRCD} \tab Object of class ssMRCD with optimally selected parameter \code{lambda}. \cr
   \tab \cr
   \code{tuning_grid} \tab Vector of lambda to tune over given by the input. \cr
   \tab \cr
   \code{tuning_values} \tab If \code{tuning$method = "residuals"} then a vector returning
   the values of the residual criteria for the corresponding values of lambda in \code{tuning_grid}.\cr
   \tab If \code{tuning$method = "local contamination"}, then matrix with false negative rates
    and the total number of flagged outliers. \cr
   \tab \cr
   \code{plot} \tab If \code{tuning$plot = TRUE}, then a plot for parameter tuning is added. \cr

}
}
\description{
The ssMRCD function calculates the spatially smoothed MRCD estimator from Puchhammer and Filzmoser (2023).
}
\details{
The necessary list elements for the parameter \code{tuning} depend on the method specified.
For both tuning approaches (residual-based or contamination-based) the element \code{method} needs to be specified to
\code{"residuals"} and \code{"local contamination"}, respectively. The boolean list element \code{plot} is available for both methods and
specifies if a plot should be constructed after tuning.

For \code{tuning$method = "local contamination"}, additional information needs to be passed.
The number of nearest neighbors \code{tuning$k} used for the local outlier detection method
is \code{10} by default. The percentage of exchanged/contaminated observations is specified
by \code{tuning$cont} and is set to \code{0.05} by default. Also the coordinates must be given in  \code{tuning$coords}
and the number of repetitions for the switching procedure, \code{tuning$repetitions}.

For \code{tuning$method = "local contamination"} no optimal value is returned but the choice has to
be made by the user. Be aware that the FNR does not take into account that there are also natural outliers
included in the data set that might or might not be found. The best parameter selection depends on the goal of the analysis
and whether false negatives should be avoided or whether the number of flagged outliers should be low.
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
ssMRCD(X = x, weights = W, lambda = 0.5)
}
\references{
Puchhammer P. and Filzmoser P. (2023). Spatially Smoothed Robust Covariance Estimation for Local Outlier Detection. \emph{Journal of Computational and Graphical Statistics, 33(3), 928–940}.  \doi{10.1080/10618600.2023.2277875}
}
\seealso{
\code{\link[ssMRCD]{plot.ssMRCD}}
}
