% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc.R
\name{select_sparsity}
\alias{select_sparsity}
\title{Optimal Sparsity Parameter Selection for PCA}
\usage{
select_sparsity(
  COVS,
  k = 1,
  rho = NULL,
  cor = FALSE,
  eta = seq(0, 5, by = 0.2),
  gamma = seq(0, 1, 0.05),
  eps_threshold = 0.001,
  eps_root = 0.1,
  eps_ADMM = 1e-04,
  n_max = 300,
  adjust_eta = FALSE,
  cores = 1,
  increase_rho = list(TRUE, 100, 1),
  convergence_plot = FALSE,
  trace = FALSE,
  stop.sparse = TRUE
)
}
\arguments{
\item{COVS}{list of covariance or correlation matrices.}

\item{k}{number of components to be returned.}

\item{rho}{penalty parameter for ADMM.}

\item{cor}{logical, if starting values for covariances or correlation matrices should be used.}

\item{eta}{vector of possible values for degree of sparsity.}

\item{gamma}{vector of possible values for distribution of sparsity. If only one value is provided, the optimal eta is calculated.}

\item{eps_threshold}{tolerance for thresholding.}

\item{eps_root}{tolerance for root finder.}

\item{eps_ADMM}{tolerance for ADMM iterations.}

\item{n_max}{maximal number of ADMM iterations.}

\item{adjust_eta}{if eta should be adjusted for further components.}

\item{cores}{number of cores for parallel computing.}

\item{increase_rho}{list of settings for improved automated calculation and convergence. See Details.}

\item{convergence_plot}{logical, if convergence plot should be plotted. Not applicable for \code{cores > 1}.}

\item{trace}{logical, if messages should be displayed. Not applicable for \code{cores > 1}.}

\item{stop.sparse}{calculate if AUC should be calculated for PCAs until full sparsity is reached (\code{TRUE})
or over the whole eta range (\code{FALSE}). Set to \code{TRUE}.}
}
\value{
Returns list with \tabular{ll}{
   \code{PCA} \tab object of type PCAloc.\cr
   \tab \cr
   \code{PC} \tab local loadings of PCA\cr
   \tab \cr
   \code{gamma} \tab optimal value for gamma. \cr
   \tab \cr
   \code{eta} \tab optimal value for eta. \cr
   \tab \cr
   \code{eta_tpo} \tab values of Trade-Off-Product for eta from optimization process. \cr
   \tab \cr
   \code{auc} \tab area under the curve for varying gamma values. \cr
   \tab \cr
   \code{pars} \tab parameters and respective sparsity entrywise and mixed and explained variance. \cr
   \tab \cr
   \code{plot} \tab ggplot object for optimal parameter selection. \cr
   \tab \cr
   \code{plot_info} \tab additional data for plotting functions. \cr
}
}
\description{
Optimal Sparsity Parameter Selection for PCA
}
\details{
The input \code{increase_rho} consists of a logical indicating if rho should be adjusted
if algorithm did not converged within the given maximal number of iterations. Two integers specify the
maximal \code{rho} that is allowed and the step size.
}
\examples{
\donttest{
C1 = matrix(c(1,0,0,0.9), ncol = 2)
C2 = matrix(c(1.1, 0.1, 0.1, 1), ncol = 2)
C3 = matrix(c(1.2, 0.2, 0.2, 1), ncol = 2)

select_sparsity(COVS = list(C1, C2, C3),
                k = 1,
                rho = 5,
                eta = c(0, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5 ,0.75,  1),
                gamma =c(0, 0.25, 0.5, 0.75, 1),
                eps_threshold = 0.005,
                increase_rho = list(FALSE, 20, 5))
}
}
