% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD_helpers.R
\name{objective_matrix}
\alias{objective_matrix}
\title{Calculation of Objective Function}
\usage{
objective_matrix(matrix_list, lambda, weights)
}
\arguments{
\item{matrix_list}{a list of matrices \eqn{K_i}}

\item{lambda}{scalar smoothing parameter}

\item{weights}{matrix of weights}
}
\value{
Returns the value of the objective function using matrices \eqn{K_i}.
}
\description{
Calculation of the value of the objective function for the \code{\link[ssMRCD]{ssMRCD}} for a given list of matrices,
lambda and a weighting matrix according to formula (3) in Puchhammer and Filzmoser (2023).
}
\examples{
# construct matrices
k1 = matrix(c(1,2,3,4), nrow = 2)
k2 = matrix(c(1,3,5,7), nrow = 2)

# construct weighting matrix
W = matrix(c(0, 1, 1, 0), nrow = 2)

objective_matrix(list(k1, k2), 0.5, W)
}
\references{
Puchhammer P. and Filzmoser P. (2023): Spatially smoothed robust covariance estimation for local outlier detection. \doi{10.48550/arXiv.2305.05371}
}
