% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-svy.r
\name{tbl_svy}
\alias{tbl_svy}
\title{tbl_svy object.}
\description{
A \code{tbl_svy} wraps a locally stored svydesign and adds methods for
dplyr single-table verbs like \code{mutate}, \code{group_by} and
\code{summarise}. Create a \code{tbl_svy} using \code{\link{as_survey_design}}.
}
\section{Methods}{


\code{tbl_df} implements these methods from dplyr.

\describe{
\item{\code{\link[dplyr]{select}} or \code{\link[dplyr]{rename}}}{
  Select or rename variables in a survey's dataset.}
\item{\code{\link[dplyr]{mutate}} or \code{\link[dplyr]{transmute}}}{
  Modify and create variables in a survey's dataset.}
\item{\code{\link{group_by}} and \code{\link{summarise}}}{
 Get descriptive statistics from survey.}
}
}
\examples{
library(survey)
data(api)
svy <- as_survey_design(apistrat, strata = stype, weights = pw)
svy

# Data manipulation verbs ---------------------------------------------------
filter(svy, pcttest > 95)
select(svy, starts_with("acs")) # variables used in survey design are automatically kept
summarise(svy, col.grad = survey_mean(col.grad))
mutate(svy, api_diff = api00 - api99)

# Group by operations -------------------------------------------------------
# To calculate survey
svy_group <- group_by(svy, dname)

summarise(svy, col.grad = survey_mean(col.grad),
          api00 = survey_mean(api00, vartype = "ci"))
}

