% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sreg_ber.R
\name{sreg_ber}
\alias{sreg_ber}
\title{Semiparametric Model-Assisted Estimation under a Bernoulli Sampling Design}
\usage{
sreg_ber(location_formula, scale_formula, data, pi)
}
\arguments{
\item{location_formula}{a symbolic description of the systematic component of the location model to be fitted.}

\item{scale_formula}{a symbolic description of the systematic component of the scale model to be fitted.}

\item{data}{a data frame, list containing the variables in the model.}

\item{pi}{numeric, represents the first order probability. Default value is 0.5.}
}
\value{
\code{sampling_design} is the name of the sampling design used in the estimation process.

\code{N} is the population size.

\code{n} is the random sample size used in the estimation process.

\code{first_order_probabilities} vector of the first order probabilities used in the estimation process.

\code{sample} is the random sample used in the estimation process.

\code{total_y_sreg} is the SREG estimate of the total parameter of the finite population.
}
\description{
\code{sreg_ber} is used to estimate the total parameter of a finite population generated from a semi-parametric generalized gamma population under a Bernoulli sampling design.
}
\examples{
#This example use the data set 'apipop' of the survey package.
library(survey)
library(dplyr)
data(api)
attach(apipop)
Apipop <- filter(apipop,full!= 'NA')
Apipop <- filter(Apipop, stype == 'H')
Apipop <- select(Apipop,c(api00,grad.sch,full))
sreg_ber(api00 ~  pb(grad.sch), scale_formula = ~ full - 1, data= Apipop, pi=0.25)
sum(Apipop$api00)
}
\references{
Sarndal C.E.,  Swensson B., and Wretman J. (2003). Model Assisted Survey Sampling. Springer.

Cardozo C.A.,  Paula G., and Vanegas L. (2021). Generalized log-gamma semiparametric models with P-spline smoothing. Submitted.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
