% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{resample}
\alias{resample}
\alias{resample.qts}
\alias{resample.qts_sample}
\title{QTS Resampling}
\usage{
resample(x, tmin = NA, tmax = NA, nout = 0L, disable_normalization = FALSE)

\method{resample}{qts}(x, tmin = NA, tmax = NA, nout = 0L, disable_normalization = FALSE)

\method{resample}{qts_sample}(x, tmin = NA, tmax = NA, nout = 0L, disable_normalization = FALSE)
}
\arguments{
\item{x}{An object of class \link{qts} or \link{qts_sample}.}

\item{tmin}{A numeric value specifying the lower bound of the time interval
over which uniform resampling should take place. It must satisfy \code{tmin >= min(qts$time)}. Defaults to \code{NA} in which case it is set to
\code{min(qts$time)}.}

\item{tmax}{A numeric value specifying the upper bound of the time interval
over which uniform resampling should take place. It must satisfy \code{tmax <= max(qts$time)}. Defaults to \code{NA} in which case it is set to
\code{max(qts$time)}.}

\item{nout}{An integer specifying the size of the uniform grid for time
resampling. Defaults to \code{0L} in which case it uses the same grid size as
the input QTS.}

\item{disable_normalization}{A boolean specifying whether quaternion
normalization should be disabled. Defaults to \code{FALSE} in which case the
function makes sure that quaternions are normalized prior to performing
SLERP interpolation.}
}
\value{
An object of the same class as the input argument \code{x} in which
quaternions are uniformly sampled in the range \verb{[tmin, tmax]}.
}
\description{
This function performs uniform resampling using SLERP.
}
\examples{
resample(vespa64$igp[[1]])
resample(vespa64$igp)
}
