% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-hclust.R
\name{hclust}
\alias{hclust}
\alias{hclust.default}
\alias{hclust.qts_sample}
\title{QTS Hierarchical Agglomerative Clustering}
\usage{
hclust(x, metric, linkage_criterion, ...)

\method{hclust}{default}(
  x,
  metric = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  linkage_criterion = c("complete", "average", "single", "ward.D2"),
  ...
)

\method{hclust}{qts_sample}(
  x,
  metric = c("l2", "pearson"),
  linkage_criterion = c("complete", "average", "single", "ward.D2"),
  n_clusters = 1L,
  warping_class = c("affine", "dilation", "none", "shift", "srsf"),
  centroid_type = "mean",
  cluster_on_phase = FALSE,
  ...
)
}
\arguments{
\item{x}{Either a numeric matrix of data, or an object that can be coerced to
such a matrix (such as a numeric vector or a data frame with all numeric
columns) or an object of class \link{qts_sample}.}

\item{metric}{A character string specifying the distance measure to be used.
This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"} if \code{x} is not a QTS sample.
Otherwise, it must be one of \code{"l2"}, \code{"pearson"} or \code{"dtw"}.}

\item{linkage_criterion}{A string specifying which linkage criterion should
be used to compute distances between sets of curves. Choices are
\code{"complete"} for complete linkage, \code{"average"} for average linkage and
\code{"single"} for single linkage. See \code{\link[stats:hclust]{stats::hclust()}} for more details.
Defaults to \code{"complete"}.}

\item{...}{Further graphical arguments.  E.g., \code{cex} controls
    the size of the labels (if plotted) in the same way as \code{\link{text}}.}

\item{n_clusters}{An integer value specifying the number of clusters.
Defaults to \code{1L}.}

\item{warping_class}{A string specifying the warping class Choices are
\code{"affine"}, \code{"dilation"}, \code{"none"}, \code{"shift"} or \code{"srsf"}. Defaults to
\code{"affine"}. The SRSF class is the only class which is boundary-preserving.}

\item{centroid_type}{A string specifying the type of centroid to compute.
Choices are \code{"mean"}, \code{"median"} \code{"medoid"}, \code{"lowess"} or \code{"poly"}.
Defaults to \code{"mean"}. If LOWESS appproximation is chosen, the user can
append an integer between 0 and 100 as in \code{"lowess20"}. This number will be
used as the smoother span. This gives the proportion of points in the plot
which influence the smooth at each value. Larger values give more
smoothness. The default value is 10\%. If polynomial approximation is
chosen, the user can append an positive integer as in \code{"poly3"}. This
number will be used as the degree of the polynomial model. The default
value is \code{4L}.}

\item{cluster_on_phase}{A boolean specifying whether clustering should be
based on phase variation or amplitude variation. Defaults to \code{FALSE} which
implies amplitude variation.}
}
\value{
An object of class \code{\link[stats:kmeans]{stats::kmeans}} or \code{\link[stats:hclust]{stats::hclust}} or
\code{dbscan_fast} if the input \code{x} is NOT of class \code{\link{qts_sample}}. Otherwise,
an object of class \code{qtsclust} which is effectively a list with four
components:
\itemize{
\item \code{qts_aligned}: An object of class \code{\link{qts_sample}} storing the sample of
aligned QTS;
\item \code{qts_centers}: A list of objects of class \code{\link{qts}} representing the centers
of the clusters;
\item \code{best_clustering}: An object of class \code{\link[fdacluster:caps]{fdacluster::caps}} storing the
results of the best k-mean alignment result among all initialization that
were tried.
\item \code{call_name}: A string storing the name of the function that was used to
produce the clustering structure;
\item \code{call_args}: A list containing the exact arguments that were passed to
the function \code{call_name} that produced this output.
}
}
\description{
This function massages the input quaternion time series to apply hierarchical
agglomerative clustering on them, with the possibility of separating
amplitude and phase variability and of choosing the source of variability
through which clusters should be searched.
}
\examples{
out <- hclust(vespa64$igp[1:10], n_clusters = 2)
plot(out)
}
