% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{smooth}
\alias{smooth}
\alias{smooth.default}
\alias{smooth.qts}
\alias{smooth.qts_sample}
\title{QTS Smoothing via SLERP Interpolation}
\usage{
smooth(x, ...)

\method{smooth}{default}(
  x,
  kind = c("3RS3R", "3RSS", "3RSR", "3R", "3", "S"),
  twiceit = FALSE,
  endrule = c("Tukey", "copy"),
  do.ends = FALSE,
  ...
)

\method{smooth}{qts}(x, alpha = 0.5, ...)

\method{smooth}{qts_sample}(x, alpha = 0.5, ...)
}
\arguments{
\item{x}{An object of class \link{qts} or \link{qts_sample}.}

\item{...}{Extra arguments passed on to next methods.}

\item{kind}{a character string indicating the kind of smoother required;
    defaults to \code{"3RS3R"}.}

\item{twiceit}{logical, indicating if the result should be \sQuote{twiced}.
    Twicing a smoother \eqn{S(y)} means \eqn{S(y) + S(y - S(y))}, i.e.,
    adding smoothed residuals to the smoothed values.  This decreases
    bias (increasing variance).}

\item{endrule}{a character string indicating the rule for smoothing at the
    boundary.  Either \code{"Tukey"} (default) or \code{"copy"}.}

\item{do.ends}{logical, indicating if the 3-splitting of ties should
    also happen at the boundaries (ends).  This is only used for
    \code{kind = "S"}.}

\item{alpha}{A numeric value in \verb{[0,1]} specifying the amount of smoothing.
The closer to one, the smoother the resulting QTS. Defaults to \code{0.5}.}
}
\value{
An object of the same class as the input argument \code{x} which is a
smooth version of the input QTS.
}
\description{
This function performs a smoothing of a QTS by SLERP interpolation.
}
\examples{
smooth(vespa64$igp[[1]])
smooth(vespa64$igp)
}
