% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-dist.R
\name{distDTW}
\alias{distDTW}
\title{Distance Matrix for Quaternion Time Series Samples}
\usage{
distDTW(
  qts_list,
  normalize_distance = TRUE,
  labels = NULL,
  resample = TRUE,
  disable_normalization = FALSE,
  step_pattern = dtw::symmetric2
)
}
\arguments{
\item{qts_list}{An object of class \link{qts_sample}.}

\item{normalize_distance}{A boolean specifying whether to compute normalized
distance between QTS. Please note that not all step patterns are
normalizable. Defaults to \code{FALSE}.}

\item{labels}{A character vector specifying labels for each QTS. Defaults to
\code{NULL} which uses row numbers as labels.}

\item{resample}{A boolean specifying whether the QTS should be uniformly
resampled on their domain before computing distances. Defaults to \code{TRUE}.}

\item{disable_normalization}{A boolean specifying whether quaternion
normalization should be disabled. Defaults to \code{FALSE} which ensures that we
always deal with unit quaternions.}

\item{step_pattern}{A \link[dtw:stepPattern]{dtw::stepPattern} specifying the local constraints on
the warping path. Defaults to \link[dtw:stepPattern]{dtw::symmetric2} which uses symmetric and
normalizable warping paths with no local slope constraints. See
\link[dtw:stepPattern]{dtw::stepPattern} for more information.}
}
\value{
A \link[stats:dist]{stats::dist} object storing the distance matrix between QTS in a
sample via DTW.
}
\description{
Distance Matrix for Quaternion Time Series Samples
}
\examples{
D <- distDTW(vespa64$igp)
}
