% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.slmfit.R
\name{fitted.slmfit}
\alias{fitted.slmfit}
\title{Extract Fitted Values from an \code{slmfit} object.}
\usage{
\method{fitted}{slmfit}(object, ...)
}
\arguments{
\item{object}{a \code{slmfit} object generated from the \code{\link{slmfit}()} function.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a vector of fitted values (estimated means)
}
\description{
Extract Fitted Values from an \code{slmfit} object.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
fitted(slmobj)
}
