% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exClusterByKruskal.R
\name{exClusterByKruskal}
\alias{exClusterByKruskal}
\title{Function of Kruskal Clustering with Spatial Distances}
\description{
This function is implementation of Kruskal Clustering for input of spatial distances.
}

\usage{
exClusterByKruskal(spcoords, mininterClusterDist = 8000,
  dist_scalor = 1000)
}
\arguments{
\item{spcoords}{Data frame with the columns of x and y coordinates.}

\item{mininterClusterDist}{Minimum intercluster distance used in Kruskal clustering.}

\item{dist_scalor}{Scaling factor for the coordinates to avoid overflow by using too big integers.}
}
\value{
  A list: (clusterid,clsCenter,sumCls,withinss,tot.withinss)
   \item{clusterid}{Cluster id for every row of the input data}
   \item{clsCenter}{Central coordinates for each the cluster}
   \item{sumCls}{Frequency summary for each cluster}
   \item{withinss}{Vector of within-cluster sum of squares, one component per cluster.}
   \item{tot.withinss}{Total within-cluster sum of squares, i.e. sum(withinss)}
}

\references{
Kruskal, J. B. (1956). On the shortest spanning subtree of a graph and the traveling salesman problem. Proceedings of the American Mathematical Society. 7: 48–50. doi:10.1090/S0002-9939-1956-0078686-7. JSTOR 2033241.

}
\author{
Lianfa Li lspatial@gmail.com
}

\examples{
  x1=rnorm(500, mean=10, sd=2)
  x2=rnorm(500,mean=20,sd=5)
  y1=rnorm(500, mean=400, sd=2)
  y2=rnorm(500,mean=200,sd=5)
  samples=data.frame(x=c(x1,x2),y=c(y1,y2))
  krClusterRes=exClusterByKruskal(samples,mininterClusterDist=100,dist_scalor =1)
}

\keyword{ kruskal }% __ONLY ONE__ keyword per line



