% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localmean.weight.R
\name{localmean.weight}
\alias{localmean.weight}
\title{Internal Function: Local Mean Variance Neighbors and Weights}
\usage{
localmean.weight(x, y, prb, nbh = 4, vincr = 1e-05 * abs(mean(y)))
}
\arguments{
\item{x}{Vector of x-coordinates for location of the sample points.}

\item{y}{Vector of y-coordinates for location of the sample points.}

\item{prb}{Vector of inclusion probabilities for the sample points.}

\item{nbh}{Number of neighboring points to use in the calculations.}

\item{vincr}{The variance increment for correcting an La.svd error.  The
default is 0.00001*abs(mean(y)).}
}
\value{
List containing two elements: a matrix named ij composed of the index
  values of neighboring points and a vector named gwt composed of weights.
}
\description{
This function calculates the index values of neighboring points and
associated weights required by the local mean variance estimator.
}
\seealso{
\code{\link{localmean.weight2}}
}
\author{
Don Stevens \email{Kincaid.Tom@epa.gov}
}
