% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sncFun.01110.R
\name{sncFun.01110}
\alias{sncFun.01110}
\title{Unimodal van Genuchten Non-Capillary Saturation Model}
\usage{
sncFun.01110(p_snc, h)
}
\arguments{
\item{p_snc}{vector of the 2 van Genuchten Mualem model and h0, the order is sensitve and has to be given as:
\tabular{lll}{
   \code{alf1}\tab{van Genuchten alpha [cm-3]}\cr
   \code{n1}\tab{van Genuchten n [-]}\cr
   \code{h0}\tab{pressure head representing oven dryness given in pF, i.e. log[10](|pressure head| [cm])}\cr
         }}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{snc}{non-capillary saturation}
}
\description{
Analytical implementation of the non-capillary saturation function \insertCite{vanGenuchten.1980}{spsh}.
}
\details{
The function is Eq. Table 1-C1 in insertRef{Streck.2020}{spsh} using eq 21 which can be used
to accelerate the convergence of the sum.
The analytical solution presented in \code{sncFun.01110} only requires the Brooks-Corey model parameters
}
\examples{
p      <- c(0.1, 0.4, .01, 2, 100, .5)
# add h0
p_snc  <- c(p[3:4], 6.8)
h      <- 10^seq(-2, 6.8, length = 197)
Se     <- shypFun.01110(p, h)$Se
snc    <- sncFun.01110(p_snc, h)
}
\references{
\insertRef{vanGenuchten.1980}{spsh}
\insertRef{Weber.2019}{spsh}
\insertRef{Streck.2020}{spsh}
}
