% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{spsGoTop}
\alias{spsGoTop}
\title{Go top button}
\usage{
spsGoTop(
  id = "gotop",
  icon = NULL,
  right = "1rem",
  bottom = "10rem",
  color = "#337ab7"
)
}
\arguments{
\item{id}{element ID}

\item{icon}{\link[shiny:icon]{shiny::icon} if you do not want to use the default rocket image}

\item{right}{character string, css style, the button's position to window right}

\item{bottom}{character string, css style, the button's position to window bottom}

\item{color}{color of the icon.}
}
\value{
a shiny component
}
\description{
add a go top button on your shiny app. When the user clicks the
button, scroll the window all the way to the top. Just add this function anywhere
in you UI.
}
\details{
The button hides if you are on very top of the page. If you scroll
down 50px, this button will appear.
}
\examples{
if(interactive()){
    library(shiny)

    ui <- fluidPage(
        h1("Scroll the page..."),
        lapply(1: 100, function(x) br()),
        spsGoTop("default"),
        spsGoTop("mid", right = "50\%",  bottom= "50\%", icon = icon("home"), color = "red"),
        spsGoTop("up", right = "95\%",  bottom= "95\%", icon = icon("arrow-up"), color = "green")
    )

    server <- function(input, output, session) {

    }

    shinyApp(ui, server)
}
}
