% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inclusion_prob.R
\name{inclusion_prob}
\alias{inclusion_prob}
\alias{becomes_ta}
\title{Calculate inclusion probabilities}
\usage{
inclusion_prob(x, n, strata = NULL, alpha = 0.001, cutoff = Inf)

becomes_ta(x, alpha = 0.001, cutoff = Inf)
}
\arguments{
\item{x}{A positive and finite numeric vector of sizes for units in the
population (e.g., revenue for drawing a sample of businesses).}

\item{n}{A positive integer vector giving the sample size for each stratum,
ordered according to the levels of \code{strata}. A single value is recycled
for all strata. Non-integers are truncated towards 0.}

\item{strata}{A factor, or something that can be coerced into one, giving
the strata associated with units in the population. The default is to place
all units into a single stratum.}

\item{alpha}{A numeric vector with values between 0 and 1 for each stratum,
ordered according to the levels of \code{strata}. Units with inclusion
probabilities greater than or equal to 1 - \code{alpha} are set to 1 for
each stratum. A single value is recycled for all strata. The default is
slightly larger than 0.}

\item{cutoff}{A positive numeric vector of cutoffs for each stratum, ordered
according to the levels of \code{strata}. Units with \code{x >= cutoff} get
an inclusion probability of 1 for each stratum. A single value is recycled
for all strata. The default does not apply a cutoff.}
}
\value{
\code{inclusion_prob()} returns a numeric vector of inclusion probabilities for
each unit in the population.

\code{becomes_ta()} returns an integer vector giving the sample size at which a
unit enters the take-all stratum.
}
\description{
Calculate stratified (first-order) inclusion probabilities.
}
\details{
Within a stratum, the inclusion probability for a unit is given by
\eqn{\pi = nx / \sum x}{\pi = n * x / \sum x}. These values can be greater
than 1 in practice, and so they are constructed iteratively by taking units
with \eqn{\pi \geq 1 - \alpha}{\pi >= 1 - \alpha} (from largest to smallest)
and assigning these units an inclusion probability of 1, with the remaining
inclusion probabilities recalculated at each step. See \code{vignette("take-all")}
for details. If \eqn{\alpha > 0}, then
any ties among units with the same size are broken by their position.

The \code{becomes_ta()} function reverses this operations and finds the critical
sample size at which a unit enters the take-all stratum. This value is
undefined for units that are always included in the sample (because their
size exceeds \code{cutoff}) or never included.
}
\note{
\code{\link[kit:topn]{kit::topn()}} is used if available to improve performance in the normal
case when the sample size is small relative to the population.
}
\examples{
# Make inclusion probabilities for a population with units
# of different size
x <- c(1:10, 100)
(pi <- inclusion_prob(x, 5))

# The last unit is sufficiently large to be included in all
# samples with two or more units
becomes_ta(x)

# Use the inclusion probabilities to calculate the variance of the
# sample size for Poisson sampling
sum(pi * (1 - pi))

}
\seealso{
\code{\link[=sps]{sps()}} for drawing a sequential Poisson sample.
}
