\name{simul.int}
\alias{simul.int}
\title{
Function for simulating survival data with interactions}
\description{
\code{simul.int} simulates survival data with exponentially distributed survival times where interactions are included. The interactions are generated by variables without effect.
}
\usage{
simul.int(seed, n = 100, p = 1000,
                              n.main = 2,
                              n.int = 2,
                              beta.main=2, 
                              beta.int = 4, 
                              censparam = 1/5, 
                              lambda = 1/20)
}
\arguments{
  \item{seed}{
seed for random number generator.
}
  \item{n}{
number of individuals in the data set.
}
  \item{p}{
number of covariates in the data set.
}
  \item{n.main}{
number of main effects with effects.
}
  \item{n.int}{
number of interactions with effects.
}
  \item{beta.main}{
effect size of main effects.
}
  \item{beta.int}{
effect size of interaction effects.
}
  \item{censparam}{
value for censoring Parameter.
}
  \item{lambda}{value for baseline hazard.
}
}

\details{
The function \code{simul.int} creates exponentially distributed survival times with baseline hazard \code{lambda}.
The number of covariates is \code{p} and the sample size is \code{n}.
All covariates are standard normal distributed.
The first \code{n.main} columns correspond to the main effects and the following \code{n.int} columns correspond to the interactions. The effect sizes of the main effects are in absolute value \code{beta.main}, whereupon the first \code{floor(n.main/2)} variables have positive effect sizes and the rest of the main effects have effect size \code{-beta.main}.
The effect sizes of the interactions are in absolute value \code{beta.inter}, where half of them are positive and half of them are negative like for the main effects.
}

\value{
\code{simul.int} returns the simulated data set and the information about the effect sizes:
\item{data}{simulated dataset with p+2 columns and n rows. The last two columns consist of exponentially distributed survival time (\code{obs.time}) and status (\code{obs.status}).}
\item{info}{information about the effect sizes of the main effects and of the included interactions.}
}



\author{
Written by Isabell Hoffmann \email{isabell.hoffmann@uni-mainz.de}.
}


%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{

# Create survival data with interactions:
simul <- simul.int(287578,n = 200, p = 1000,
                          beta.int = 1.0,
                          beta.main = 0.9, 
                          censparam = 1/20, 
                          lambda = 1/20)
#Show the effect sizes of the main effects and interactions of the simulated data set:
simul$info

# Extract the data set:
data <- simul$data

# Plot the Kaplan Meier:
simul.fit <- survfit(Surv(obs.time,obs.status) ~ 1, data = data)
plot(simul.fit)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
