% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix.R
\name{rnormmix}
\alias{rnormmix}
\title{Generate a mixture with normal components}
\usage{
rnormmix(m, sig0, df = 10, rand_m = FALSE, xlim = c(0, 1), ylim = c(0,
  1), dvec, mu0, Sigma0)
}
\arguments{
\item{m}{Number of components of the mixture.}

\item{sig0}{Tuning parameter for generating a random matrix from an Inverse Wishart
distribution. If this argument is missing it is set to .1 of the minimum width/height of the window.}

\item{df}{Degrees of freedom for generating a random matrix from an Inverse Wishart
distribution. Default is 10.}

\item{rand_m}{Request a random number of components.
When \code{rand_m = TRUE}, the function will
randomly choose a number of components from
\code{1:m}.}

\item{xlim, ylim}{Vectors defining the observation window.
The component means are sampled uniformly over this window.}

\item{dvec}{A vector of weights used in the Dirichlet distribution used to sample the mixture probabilities. If the dimension of dvec is not
the same as the number of components, then dvec is either truncated to the same dimension or repeated to have dimension m. If missing, a vector of ones is used.}

\item{mu0, Sigma0}{Mean and covariance matrix for a multivariate normal distribution, used to generate all component means. If mu0 is missing the center of the window
is used. If Sigma0 is missing it is set to the identity matrix. If both mu0 and Sigma0 are missing, the component means are generated uniformly over the window of observation.}
}
\value{
Object of class \code{normmix}.
}
\description{
Generates a mixture on a 2d window where the means, covariances and component probabilities
are chosen randomly. The number of components can be either fixed or random.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#rnormmix}
}
\examples{
\donttest{
mix1 <- rnormmix(m = 3, sig0 = .1, df = 5)
summary(mix1)
mix2 <- rnormmix(m = 5, sig0 = .1, df = 5, rand_m = TRUE, ylim = c(0, 5))
summary(mix2)}

}
\author{
Sakis Micheas, Yuchen Wang
}
