% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_autocorr}
\alias{plot_autocorr}
\title{Checking convergence: autocorrelation plot}
\usage{
plot_autocorr(chain, open_new_window = FALSE, maxlag = 100)
}
\arguments{
\item{chain}{An \code{Lx1} vector containing the \code{L} posterior realizations.}

\item{open_new_window}{Open a new window for the plot.}

\item{maxlag}{The maximum lag value to consider. Default is 100.}
}
\description{
This function can be used to assess
convergence by visualizing the
autocorrelations between the draws of the
Markov chain \code{chain}. The \code{lag k}
autocorrelation \code{rho_k} is the correlation between every draw
and its \code{kth} lag. We would expect the
\code{kth} lag autocorrelation to be
smaller as \code{k} increases (that is, the
100th and 1000th draws should be less
correlated than the 100th and 105th draws).
For higher values of k we anticipate small
autocorrelation values, otherwise the chain
is not \code{mixing} well (in other words we do not
explore the parameter space adequately).

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot_autocorr}
}
\examples{
\donttest{
truemix_surf <- rmixsurf(m = 3, lambda=100, xlim = c(-3,3), ylim = c(-3,3))
plot(truemix_surf)
genPPP=rsppmix(intsurf = truemix_surf, truncate = FALSE)
fit <- est_mix_damcmc(pp = genPPP, m = 3)
plot_autocorr(fit$genps[,1])
plot_autocorr(fit$genps[,2])
plot_autocorr(fit$genps[,3])}

}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{rmixsurf}},
\code{\link{rsppmix}}
}
\author{
Sakis Micheas
}
