% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shows.R
\name{get_show_episodes}
\alias{get_show_episodes}
\title{Get Spotify catalog information about an show's episodes. Optional parameters can be used to limit the number of episodes returned.}
\usage{
get_show_episodes(
  id,
  limit = 20,
  offset = 0,
  market = NULL,
  authorization = get_spotify_authorization_code(),
  include_meta_info = FALSE
)
}
\arguments{
\item{id}{Required. The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the show.}

\item{limit}{Optional. \cr
Maximum number of results to return. \cr
Default: 20 \cr
Minimum: 1 \cr
Maximum: 50 \cr}

\item{offset}{Optional. \cr
The index of the first album to return. \cr
Default: 0 (the first album). \cr
Maximum offset (including limit): 10,000. \cr
Use with limit to get the next set of episodes.}

\item{market}{Optional. \cr
An \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code} or the string
\code{"from_token"}. If a country code is specified, only shows and episodes that are available in that market will be returned.
If a valid user access token is specified in the request header, the country associated with the user account will take priority over
this parameter.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the
\href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details.
Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. \cr
Reading the user’s resume points on episode objects requires the user-read-playback-position scope. See
\href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"},
and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing show data. See the official API \href{https://developer.spotify.com/documentation/web-api/reference/shows/get-shows-episodes/}{documentation} for more information.
}
\description{
Get Spotify catalog information about an show's episodes. Optional parameters can be used to limit the number of episodes returned.
}
