% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{get_playlist_audio_features}
\alias{get_playlist_audio_features}
\title{Get features and popularity for all of a given set of playlists on Spotify}
\usage{
get_playlist_audio_features(username, playlist_uris,
  authorization = get_spotify_access_token())
}
\arguments{
\item{username}{String of Spotify username. Can be found on the Spotify app.}

\item{playlist_uris}{Character vector of Spotify playlist uris. Can be found within the Spotify App}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}
}
\description{
This function returns the popularity and audio features for every song for a given set of playlists on Spotify
}
\examples{
\dontrun{
playlist_username <- 'spotify'
playlist_uris <- c('37i9dQZF1E9T1oFsQFg98K', '37i9dQZF1CyQNOI21QVf3p')
playlist_audio_features <- get_playlist_audio_features(playlist_username, playlist_uris)
}
}
\keyword{audio}
\keyword{features}
\keyword{playlists}
\keyword{track}
