% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{as_previews.spork}
\alias{as_previews.spork}
\title{Compare Previews of Spork}
\usage{
\method{as_previews}{spork}(x, wide = 70, long = 20, width = 3, height = 1, sleep = 2, ...)
}
\arguments{
\item{x}{length-one spork}

\item{wide}{width in mm of the latex image}

\item{long}{length in mm of the latex image}

\item{width}{width (default: inches) of the plotmath image}

\item{height}{height (default: inches) of the plotmath image}

\item{sleep}{how long to pause after html before latex/plotmath}

\item{...}{passed arguments}
}
\value{
invisible list of filepaths
}
\description{
Compares plotmath and latex previews of spork
Generates png for both, and overlays
latex above plotmath.
}
\examples{
library(magrittr)
specials <- '& \% $ # \\\\_ { } ~ \\\\^ \\\\'
\donttest{
# specials \%>\% as_spork \%>\% as_previews
# specials \%>\% gsub(' ','',.) \%>\% as_spork \%>\% as_previews
# 'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_previews

# disambiguation for plotmath and latex (see \code{\link[grDevices]{plotmath}}):

# 'epsilon.varepsilon' \%>\% as_spork \%>\% as_previews
# 'rho.varrho' \%>\% as_spork \%>\% as_previews
# 'Upsilon.Upsilon1' \%>\% as_spork \%>\% as_previews
# 'phi.phi1.varphi' \%>\% as_spork \%>\% as_previews
# 'sigma.sigma1.varsigma.stigma' \%>\% as_spork \%>\% as_previews
# 'theta.vartheta.theta1' \%>\% as_spork \%>\% as_previews
# 'omega.omega1.pi.varpi' \%>\% as_spork \%>\% as_previews
}
}
\seealso{
Other preview: 
\code{\link{as.png.plotmath}()},
\code{\link{as.png.spork}()},
\code{\link{as_preview.html}()},
\code{\link{as_preview.latex}()},
\code{\link{as_preview.plotmath}()},
\code{\link{as_previews.default}()},
\code{\link{as_previews}()},
\code{\link{as_preview}()},
\code{\link{ggplot.plotmath}()},
\code{\link{ggplot.spork}()}

Other interface: 
\code{\link{as.expression.plotmath}()},
\code{\link{as_html.spar}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.spar}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_spork.character}()},
\code{\link{htmlToken}()},
\code{\link{latexToken}()},
\code{\link{plotmathToken}()}

Other spork: 
\code{\link{[.spork}()},
\code{\link{[[.spork}()},
\code{\link{as.list.spork}()},
\code{\link{as.png.spork}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_spar.default}()},
\code{\link{as_spar.spork}()},
\code{\link{as_spork.character}()},
\code{\link{as_spork.factor}()},
\code{\link{as_spork.spork}()},
\code{\link{as_spork}()},
\code{\link{ggplot.spork}()},
\code{\link{greek}()}
}
\concept{interface}
\concept{preview}
\concept{spork}
