% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.antweb.R
\name{as.antweb}
\alias{as.antweb}
\title{Coerce occurrence keys to antwebkey/occkey objects}
\usage{
as.antweb(x, ...)
}
\arguments{
\item{x}{Various inputs, including the output from a call to \code{\link[=occ]{occ()}}
(class occdat), \code{\link[=occ2df]{occ2df()}} (class data.frame), or a list, numeric,
character, or antwebkey, or occkey.}

\item{...}{curl options; named parameters passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
One or more in a list of both class antwebkey and occkey
}
\description{
Coerce occurrence keys to antwebkey/occkey objects
}
\examples{
\dontrun{
spp <- c("linepithema humile", "acanthognathus")
out <- occ(query=spp, from='antweb', limit=2)
res <- occ2df(out)
(tt <- as.antweb(out))
(uu <- as.antweb(res))
as.antweb(res$key[1])
as.antweb(as.list(res$key[1:2]))
as.antweb(tt[[1]])
as.antweb(uu[[1]])
as.antweb(tt[1:2])
}
}
