% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R, R/vcov_glm.R
\name{vcov.spmodel}
\alias{vcov.spmodel}
\alias{vcov.splm}
\alias{vcov.spautor}
\alias{vcov.spglm}
\alias{vcov.spgautor}
\title{Calculate variance-covariance matrix for a fitted model object}
\usage{
\method{vcov}{splm}(object, ...)

\method{vcov}{spautor}(object, ...)

\method{vcov}{spglm}(object, var_correct = TRUE, ...)

\method{vcov}{spgautor}(object, var_correct = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{var_correct}{A logical indicating whether to return the corrected variance-covariance
matrix for models fit using \code{\link[=spglm]{spglm()}} or \code{\link[=spgautor]{spgautor()}}. The default is
\code{TRUE}.}
}
\value{
The variance-covariance matrix of coefficients obtained via \code{coef()}.
Currently, only the variance-covariance matrix of the fixed effects is supported.
}
\description{
Calculate variance-covariance matrix for a fitted model object.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
vcov(spmod)
}
