% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splot.color}
\alias{splot.color}
\title{splot colors}
\usage{
splot.color(set = "pastel", by = NULL, ns = 1, maxiter = 1000,
  flat = TRUE)
}
\arguments{
\item{set}{the name of a set (matching \code{'bright'}, \code{'dark'}, \code{'pastel'}, or
\code{'gray'} or \code{'grey'}), or a vector of color names or hex codes. See the details section.}

\item{by}{a factor-like variable; this will be used to set \code{ns} via \code{\link[base]{table}}.}

\item{ns}{a single value, or vector of values specifying the number of colors to generate.}

\item{maxiter}{the maximum number of iterations allowed when colors are being randomly sampled.}

\item{flat}{logical; if \code{FALSE}, if \code{by} is specified, a matrix is returned with two columns
(group and color), and if \code{by} is missing, a list is returned with seed colors as names. Otherwise,
a vector with all generated colors is returned, either in order of generation (if \code{by} is missing),
or in the same order as \code{by}.}
}
\description{
Get a prespecified set of 9 colors, a greyscale, or a set of random, grouped colors.
}
\details{
If only \code{set} is specified, either a prespecified vector of color codes is returned (if
\code{set} is a single string, and matches one of \code{'bright'}, \code{'dark'}, or \code{'pastel'}),
or a version of the entered vector, with color names converted to hex codes (e.g.,
\code{splot.color(c('red','green','blue'))} would return \code{c('#ff0000','#00ff00','#0000ff')}).

If \code{set} matches \code{'gray'} or \code{'grey'}, a single vector of colors codes is returned,
corresponding to either the length of \code{by} (if not missing) or the sum of \code{ns}.

Otherwise, if \code{by} or \code{ns} is not missing, a set of colors is sampled for each value of
\code{ns} (where \code{ns=table(by)} if \code{by} is not missing). In this case, \code{set} determines the
seed color for each sample (e.g., if \code{set[1]='red'}, \code{ns[1]} colors similar to \code{'red'}
would be sampled).
}
\examples{
x=rnorm(1000)
y=rnorm(1000)

# get a quick feel for the range of colors
plot(y~x,pch=20,cex=10,col=splot.color(ns=c(20,20)))

# with more extreme seed colors, differences are subtler
plot(y~x,pch=20,cex=10,col=splot.color(c('red','blue'),ns=c(20,20)))

}
