//
// R package splines2 by Wenjie Wang and Jun Yan
// Copyright (C) 2016-2020
//
// This file is part of the R package splines2.
//
// The R package splines2 is free software: You can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or any later
// version (at your option). See the GNU General Public License at
// <https://www.gnu.org/licenses/> for details.
//
// The R package splines2 is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//

// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppArmadillo.h>
#include <Rcpp.h>

using namespace Rcpp;

// rcpp_bSpline_basis
Rcpp::NumericMatrix rcpp_bSpline_basis(const arma::vec& x, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_bSpline_basis(SEXP xSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_bSpline_basis(x, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_bSpline_derivative
Rcpp::NumericMatrix rcpp_bSpline_derivative(const arma::vec& x, const unsigned int derivs, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_bSpline_derivative(SEXP xSEXP, SEXP derivsSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type derivs(derivsSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_bSpline_derivative(x, derivs, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_bSpline_integral
Rcpp::NumericMatrix rcpp_bSpline_integral(const arma::vec& x, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_bSpline_integral(SEXP xSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_bSpline_integral(x, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_bernsteinPoly
Rcpp::NumericMatrix rcpp_bernsteinPoly(const arma::vec& x, const unsigned int degree, const unsigned int derivs, const bool integral, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_bernsteinPoly(SEXP xSEXP, SEXP degreeSEXP, SEXP derivsSEXP, SEXP integralSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type derivs(derivsSEXP);
    Rcpp::traits::input_parameter< const bool >::type integral(integralSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_bernsteinPoly(x, degree, derivs, integral, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_cSpline_basis
Rcpp::NumericMatrix rcpp_cSpline_basis(const arma::vec& x, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_cSpline_basis(SEXP xSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_cSpline_basis(x, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_cSpline_derivative
Rcpp::NumericMatrix rcpp_cSpline_derivative(const arma::vec& x, const unsigned int derivs, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_cSpline_derivative(SEXP xSEXP, SEXP derivsSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type derivs(derivsSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_cSpline_derivative(x, derivs, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_iSpline_basis
Rcpp::NumericMatrix rcpp_iSpline_basis(const arma::vec& x, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_iSpline_basis(SEXP xSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_iSpline_basis(x, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_iSpline_derivative
Rcpp::NumericMatrix rcpp_iSpline_derivative(const arma::vec& x, const unsigned int derivs, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_iSpline_derivative(SEXP xSEXP, SEXP derivsSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type derivs(derivsSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_iSpline_derivative(x, derivs, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_iSpline_integral
Rcpp::NumericMatrix rcpp_iSpline_integral(const arma::vec& x, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_iSpline_integral(SEXP xSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_iSpline_integral(x, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_mSpline_basis
Rcpp::NumericMatrix rcpp_mSpline_basis(const arma::vec& x, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_mSpline_basis(SEXP xSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_mSpline_basis(x, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}
// rcpp_mSpline_derivative
Rcpp::NumericMatrix rcpp_mSpline_derivative(const arma::vec& x, const unsigned int derivs, const unsigned int df, const unsigned int degree, const arma::vec& internal_knots, const arma::vec& boundary_knots, const bool complete_basis);
RcppExport SEXP _splines2_rcpp_mSpline_derivative(SEXP xSEXP, SEXP derivsSEXP, SEXP dfSEXP, SEXP degreeSEXP, SEXP internal_knotsSEXP, SEXP boundary_knotsSEXP, SEXP complete_basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const arma::vec& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type derivs(derivsSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type df(dfSEXP);
    Rcpp::traits::input_parameter< const unsigned int >::type degree(degreeSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type internal_knots(internal_knotsSEXP);
    Rcpp::traits::input_parameter< const arma::vec& >::type boundary_knots(boundary_knotsSEXP);
    Rcpp::traits::input_parameter< const bool >::type complete_basis(complete_basisSEXP);
    rcpp_result_gen = Rcpp::wrap(rcpp_mSpline_derivative(x, derivs, df, degree, internal_knots, boundary_knots, complete_basis));
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_splines2_rcpp_bSpline_basis", (DL_FUNC) &_splines2_rcpp_bSpline_basis, 6},
    {"_splines2_rcpp_bSpline_derivative", (DL_FUNC) &_splines2_rcpp_bSpline_derivative, 7},
    {"_splines2_rcpp_bSpline_integral", (DL_FUNC) &_splines2_rcpp_bSpline_integral, 6},
    {"_splines2_rcpp_bernsteinPoly", (DL_FUNC) &_splines2_rcpp_bernsteinPoly, 6},
    {"_splines2_rcpp_cSpline_basis", (DL_FUNC) &_splines2_rcpp_cSpline_basis, 6},
    {"_splines2_rcpp_cSpline_derivative", (DL_FUNC) &_splines2_rcpp_cSpline_derivative, 7},
    {"_splines2_rcpp_iSpline_basis", (DL_FUNC) &_splines2_rcpp_iSpline_basis, 6},
    {"_splines2_rcpp_iSpline_derivative", (DL_FUNC) &_splines2_rcpp_iSpline_derivative, 7},
    {"_splines2_rcpp_iSpline_integral", (DL_FUNC) &_splines2_rcpp_iSpline_integral, 6},
    {"_splines2_rcpp_mSpline_basis", (DL_FUNC) &_splines2_rcpp_mSpline_basis, 6},
    {"_splines2_rcpp_mSpline_derivative", (DL_FUNC) &_splines2_rcpp_mSpline_derivative, 7},
    {NULL, NULL, 0}
};

RcppExport void R_init_splines2(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
