% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_request.R
\name{as_response}
\alias{as_response}
\title{Return a HAR entry response as an httr::response object}
\usage{
as_response(har_entry)
}
\arguments{
\item{har_entry}{a HAR object (should contain a response body to be most useful)}
}
\description{
Return a HAR entry response as an httr::response object
}
\examples{
\dontrun{
library(purrr)

URL <- "http://www.svs.cl/portal/principal/605/w3-propertyvalue-18554.html"

splash_local \%>\%
  splash_response_body(TRUE) \%>\%
  splash_user_agent(ua_macos_chrome) \%>\%
  splash_go(URL) \%>\%
  splash_wait(2) \%>\%
  splash_har() -> har

keep(har$log$entries, is_xhr) \%>\%
  map(as_request) \%>\%
  map(httr::content, as="parsed")
}
}
