% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.r
\name{render_gganimate}
\alias{render_gganimate}
\title{Render the slides as a \emph{gganimate} animation}
\usage{
render_gganimate(slides, manip_col = "blue", col = "black", pch = 20,
  axes = "center", fps = 3, ...)
}
\arguments{
\item{slides}{The result of \code{array2df()}, a long df of the projected frames.}

\item{manip_col}{String of the color to highlight the \code{manip_var}.
Defaults to "blue".}

\item{col}{Color of the projected points. Defaults to "black".}

\item{pch}{Point character of the projected points. Defaults to 20.}

\item{axes}{Position of the axes: "center", "bottomleft" or "off". Defaults
to "center".}

\item{fps}{Frames/slides shown per second. Defaults to 3.}

\item{...}{Optional, pass addition arguments to
\code{gganimate::transition_states()}.}
}
\description{
Takes the result of \code{array2df()} and renders them into a
\emph{gganimate} animation.
}
\examples{
\dontrun{
flea_std <- tourr::rescale(tourr::flea[, 1:6])

rb <- basis_random(n = ncol(flea_std))
mtour <- manual_tour(basis = rb, manip_var = 4)
sshow <- array2df(array = mtour, data = flea_std)
render_gganimate(slides = sshow)

render_gganimate(slides = sshow, col = col_of(flea$species), 
  axes = "bottomleft", fps = 2)
}
}
