% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.r
\name{play_manual_tour}
\alias{play_manual_tour}
\title{Render display of a manual tour}
\usage{
play_manual_tour(data, basis = NULL, manip_var, theta = NULL,
  phi_min = 0, phi_max = 0.5 * pi, angle = 0.05,
  manip_col = "blue", render_type = render_plotly, col = "black",
  pch = 20, axes = "center", fps = 3, init_rescale_data = FALSE,
  ...)
}
\arguments{
\item{data}{(n, p) dataset to project, consisting of numeric variables.}

\item{basis}{A (p, d) dim orthonormal numeric matrix.
If it's left null, random basis will be used.}

\item{manip_var}{Number of the column/dimension to rotate.}

\item{theta}{Angle in radians of "in-plane" rotation, on the XY plane of the
reference frame.
If left NULL, will initialize the radial angle of the \code{manip_var}.`}

\item{phi_min}{Minimum value phi should move to. Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, defaults to 0.}

\item{phi_max}{Maximum value phi should move to. Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, defaults to pi / 2.}

\item{angle}{target distance (in radians) between bases.}

\item{manip_col}{String of the color to highlight the \code{manip_var}.}

\item{render_type}{Which graphics to render to. Defaults to render_plotly,
alternative use render_gganimate.}

\item{col}{Color of the projected points. Defaults to "black".}

\item{pch}{Point character of the projected points. Defaults to 20.}

\item{axes}{Position of the axes: "center", "bottomleft" or "off". Defaults
to "center".}

\item{fps}{Frames/slides shown per second. Defaults to 3.}

\item{init_rescale_data}{When TRUE will apply \code{tourr::rescale()} on the data.
Defaults to FALSE.}

\item{...}{Optionally pass additional arguments to the \code{render_type} for
plotting options.}
}
\value{
An animation of a manual tour.
}
\description{
Performs the sepicify manual tour and returns an animation of \code{render_type}.
For use with \code{tourr::save_history()} tour paths see \code{play_tour_path()}.
A wrapper function for \code{manual_tour()}, \code{array2df()}, and \code{render_()}.
}
\examples{
\dontrun{
flea_std <- tourr::rescale(tourr::flea[,1:6])
rb <- tourr::basis_random(n = ncol(flea_std))

play_manual_tour(data = flea_std, basis = rb, manip_var = 4)

play_manual_tour(data = flea_std, basis = rb, manip_var = 6, 
  render_type = render_gganimate, col = col_of(flea$species), axes = "bottomleft")
}
}
