% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssGAMDesign.R
\name{ssGAMDesign}
\alias{ssGAMDesign}
\title{Generate design and model information for \code{spikeSlabGAM}}
\usage{
ssGAMDesign(formula, data, specials = c("u", "lin", "fct", "sm", "rnd", "mrf",
  "srf"), minUniqueValues = 6, lowRankInteractions = TRUE,
  orthogonalizeInteractions = TRUE, decomposition = NULL)
}
\arguments{
\item{formula}{the model formula. Follows the usual R syntax described in
\code{\link[stats]{formula}}. Terms in the formula that are not in the list
of specials are automatically assigned an appropriate special, i.e.
numerical covariates \code{x} are treated as \code{lin(x) + sm(x)}, factors
\code{f} are treated as \code{fct(f)} (see \code{specials} argument). See
\code{\link{spikeSlabGAM}} for more details.}

\item{data}{\code{data.frame} containing all the variables in the function}

\item{specials}{a vector of the types of possible model terms. These must be
implemented as functions generating a design matrix with a label attribute.
See also \code{\link{sm}()} for an example. The documentation for
\code{\link{spikeSlabGAM}} contains a list of implemented model term types
and usage examples.}

\item{minUniqueValues}{the minimal number of unique values a covariate has to
have in order to not be treated as a factor. Defaults to 6.}

\item{lowRankInteractions}{should a low-rank approximation of the design
matrix for interaction terms based on a (truncated) spectral decomposition
of the implied covariance matrix be used? defaults to TRUE.}

\item{orthogonalizeInteractions}{should the design matrices for interaction
terms be projected into the complement of the column space of the
respective main effects?  Can help separate marginal and interaction
effects. Defaults to TRUE.}

\item{decomposition}{which decomposition to use, see \code{\link{sm}}.
Defaults to the default of \code{\link{sm}}.}
}
\value{
a list with components: \item{response}{the left hand side of the
  model formula} \item{Design}{the design matrix of the model specified in
  formula} \item{groupIndicators}{a factor that maps the columns of
  \code{Design} to the different model terms} \item{H}{a matrix containing
  the hierarchy of the penalization groups (not used, included for backwards
  compatibility)}
}
\description{
This function generates the design matrix for a generalized additive (mixed)
model, based on smoothing spline ANOVA-like orthogonal decomposition of the
model terms and their interactions. It parses the formula given to
\code{\link{spikeSlabGAM}} to provide all the arguments necessary for the
MCMC sampler.
}
\details{
Setting \code{lowRankInteractions} to FALSE can result in very large models,
especially if higher-order interactions or interactions between terms with
lots of parameters are involved. Note that numeric covariates with fewer
unique values than \code{minUniqueValues} are treated as factors unless
wrapped in a special argument.

This function is not meant to be called directly by the user,
\code{\link{spikeSlabGAM}} is the user interface.
}
\author{
Fabian Scheipl
}

