% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/titv.R
\name{titv}
\alias{titv}
\title{Number of pairwise transitions and transversions in an alignment.}
\usage{
titv(DNAbin)
}
\arguments{
\item{DNAbin}{A DNA alignment of class `DNAbin'.}
}
\value{
A square matrix with dimensions of \code{length(dat)}. The upper
triangle contains the number of transversions. The lower triangle contains
the number of transitions.
}
\description{
Calculates the number of pairwise transitions and transversions between
sequences.
}
\examples{

data(dolomedes)

subs <- titv(dolomedes)

#Transversions
subs[upper.tri(subs)]
tv <- t(subs)
tv <- tv[lower.tri(tv)]

#Transitions
ti <- subs[lower.tri(subs)]


#Saturation plot
doloDist <- ape::dist.dna(dolomedes)
graphics::plot(doloDist, ti, type="p", pch=19, col="blue", 
    main="Saturation plot of number of transitions and transversions\\n
    against K2P distance. Red: transversions. Blue: transitions")
graphics::points(doloDist, tv, pch=19, col="red")


}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Utilities}
